/**
 * FreeRDP: A Remote Desktop Protocol Client
 * Bitmap Unit Tests
 *
 * Copyright 2011 Jay Sorg <jay.sorg@gmail.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <freerdp/freerdp.h>
#include <freerdp/utils/hexdump.h>
#include <freerdp/utils/stream.h>
#include <freerdp/codec/bitmap.h>

#include "test_bitmap.h"

uint8 compressed_16x1x8[] =
{
0x10
};

uint8 decompressed_16x1x8[] =
{
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

uint8 compressed_32x32x8[] =
{
0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x06, 0x06, 0xed, 0x06, 0x06, 0x06, 0xed, 0x06, 0x06, 0x06,
0xec, 0x6c, 0x0e, 0x0e, 0x44, 0x0e, 0x0e, 0x0e, 0x13, 0x06, 0x06, 0x06, 0xed, 0x06, 0x06, 0x06,
0xed, 0x06, 0x06, 0x06, 0x00, 0x00, 0xe4, 0x04, 0x06, 0x8e, 0x60, 0x0e, 0x60, 0x8c, 0xb4, 0xb5,
0xdc, 0xdc, 0xbb, 0xb4, 0x8c, 0x66, 0x0b, 0x6c, 0xe4, 0x04, 0x06, 0x02, 0x8b, 0x06, 0x06, 0xed,
0x06, 0xed, 0x06, 0xf8, 0x0e, 0x66, 0xb4, 0xdc, 0x68, 0xe2, 0x97, 0xdd, 0xb4, 0xa7, 0x16, 0x06,
0x06, 0x06, 0xed, 0x06, 0xed, 0x06, 0x00, 0x00, 0x00, 0x06, 0x04, 0x06, 0x00, 0x06, 0x0b, 0xae,
0xdc, 0xe9, 0x6a, 0xdc, 0x96, 0xe9, 0xe9, 0xb4, 0x0e, 0x00, 0x06, 0x04, 0x06, 0x00, 0x06, 0x00,
0x00, 0x06, 0x06, 0xed, 0x06, 0x06, 0x0e, 0xae, 0xdc, 0xdb, 0xdb, 0xd0, 0x09, 0x07, 0xcf, 0x03,
0x95, 0xdb, 0xdb, 0xdc, 0xb4, 0x66, 0x6c, 0xed, 0x06, 0x06, 0x06, 0x00, 0x00, 0x04, 0x06, 0x04,
0x06, 0x0b, 0xae, 0xdb, 0xd4, 0xd5, 0x6c, 0xdb, 0x80, 0xaf, 0xd5, 0xd4, 0xdb, 0xb4, 0x66, 0x04,
0x06, 0x04, 0x06, 0x00, 0x00, 0xed, 0x06, 0xed, 0x66, 0xae, 0xd5, 0xad, 0xd4, 0xd4, 0xd5, 0xd5,
0xd5, 0xdb, 0xb4, 0xb4, 0xb4, 0xb4, 0xb4, 0xd5, 0xd5, 0xd5, 0xd4, 0xd4, 0xad, 0xd5, 0xb4, 0x0e,
0x06, 0x06, 0x06, 0x00, 0x00, 0x00, 0x06, 0x60, 0xa7, 0xb4, 0xad, 0xad, 0xad, 0xb3, 0xb3, 0xd4,
0xd4, 0xb3, 0x8c, 0xb6, 0x07, 0xb6, 0x8c, 0xb3, 0xd4, 0xb3, 0xb3, 0xad, 0xad, 0xad, 0xb4, 0xad,
0x66, 0x00, 0x06, 0x00, 0x00, 0x06, 0x06, 0x66, 0xae, 0xad, 0x8b, 0xad, 0xad, 0xad, 0xad, 0xad,
0xb3, 0xad, 0xb5, 0x07, 0x07, 0x07, 0xf0, 0x8b, 0xad, 0xad, 0xad, 0xad, 0xad, 0x8b, 0xa7, 0xae,
0xa7, 0x6c, 0x06, 0x00, 0x00, 0x04, 0x6c, 0xa7, 0xad, 0xa7, 0xa7, 0x8b, 0xad, 0xad, 0xad, 0xad,
0xad, 0xad, 0xb5, 0xbd, 0xbd, 0xbd, 0xbd, 0xf0, 0x8b, 0x8b, 0xad, 0x8b, 0x8b, 0xa7, 0xa7, 0xc8,
0xc8, 0x60, 0x06, 0x00, 0x00, 0x06, 0x66, 0xc8, 0xa7, 0x66, 0xa7, 0xa7, 0x8b, 0x8b, 0x8b, 0x8b,
0xad, 0x8b, 0x92, 0xf1, 0xf1, 0xf1, 0xf1, 0xf2, 0x07, 0xa7, 0xa7, 0x8b, 0xa7, 0xa7, 0x66, 0x66,
0xc8, 0x66, 0x06, 0x00, 0x00, 0x00, 0x60, 0xa7, 0x66, 0x66, 0x66, 0xa7, 0xa7, 0xa7, 0xa7, 0x8b,
0x8b, 0x8b, 0xa7, 0xb6, 0xf3, 0xf3, 0xf3, 0xf3, 0xf3, 0x07, 0x66, 0xa7, 0xa7, 0x66, 0x66, 0x66,
0xa7, 0xa7, 0x6c, 0x00, 0x00, 0x6c, 0x04, 0xa7, 0x60, 0x6b, 0x66, 0x99, 0xb6, 0xf5, 0xf5, 0xf5,
0xf5, 0xf5, 0xef, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0xa7, 0x66, 0x00, 0x00, 0x60, 0xa7, 0x66,
0x60, 0x66, 0x66, 0x8c, 0xf1, 0x6e, 0xff, 0x85, 0xbd, 0x66, 0x66, 0x66, 0x60, 0x05, 0x87, 0x13,
0x04, 0x66, 0x66, 0x66, 0x66, 0xf4, 0x70, 0xff, 0x84, 0xbd, 0x66, 0x66, 0x66, 0x05, 0x85, 0x0b,
0xa7, 0xb5, 0xae, 0x8c, 0xd0, 0x13, 0xc1, 0x01, 0x00, 0x08, 0x8e, 0x8c, 0xae, 0xb5, 0xae, 0x66,
0x00, 0x00, 0x6c, 0xae, 0xbc, 0xb5, 0xb5, 0xae, 0xb5, 0xd0, 0x0e, 0x0c, 0x01, 0x00, 0x90, 0xf2,
0xae, 0xae, 0xb5, 0xb5, 0xbc, 0xb5, 0x66, 0x00, 0x00, 0x04, 0xae, 0x0a, 0xb5, 0xb5, 0xb5, 0x68,
0xae, 0x82, 0x8c, 0x0a, 0x05, 0x8c, 0xf2, 0xae, 0xae, 0xb5, 0xb5, 0xb5, 0xbc, 0xb5, 0x6c, 0x00,
0x00, 0x06, 0x05, 0x81, 0xd0, 0x06, 0x9a, 0x8c, 0x0a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0xae,
0xae, 0xd0, 0xb5, 0xb5, 0xb5, 0x0a, 0xb5, 0x6c, 0x00, 0x00, 0x00, 0x8b, 0x0a, 0xbc, 0xb5, 0xb5,
0xb5, 0x06, 0x9b, 0xb6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0xae, 0xae, 0xae, 0xb5, 0xb5, 0xb5,
0xb6, 0x0a, 0x8c, 0x06, 0x00, 0x00, 0x06, 0x6c, 0xb5, 0x0a, 0xb6, 0xb5, 0xb5, 0xb5, 0x05, 0x80,
0x7d, 0xbc, 0xff, 0xff, 0xff, 0xff, 0xf2, 0xae, 0xae, 0xae, 0xb5, 0xb5, 0xb5, 0xb6, 0x0a, 0x0a,
0x8b, 0x06, 0x00, 0x00, 0x04, 0x06, 0x87, 0x0a, 0xbc, 0xb6, 0xb5, 0xb5, 0xb5, 0xd0, 0xae, 0xae,
0xae, 0xb6, 0xff, 0xff, 0xff, 0xf2, 0xd0, 0xae, 0xd0, 0xb5, 0xb5, 0xb5, 0xb6, 0xbc, 0x1a, 0xb5,
0x04, 0x06, 0x00, 0x00, 0xed, 0x06, 0x6e, 0xb5, 0x0a, 0xbc, 0xb6, 0xb5, 0xb5, 0xb5, 0xd0, 0xd0,
0xd0, 0xb5, 0xf4, 0xff, 0xf2, 0xd0, 0xd0, 0xd0, 0xb5, 0xb5, 0xb5, 0xb6, 0xbc, 0x0a, 0x0a, 0x8b,
0x06, 0x06, 0x00, 0x00, 0x00, 0x06, 0x04, 0x8b, 0xbc, 0x1a, 0x0a, 0xb6, 0xb6, 0xb5, 0xb5, 0xb5,
0xb5, 0xb5, 0xd0, 0xb5, 0xb5, 0xb5, 0xb5, 0xb5, 0xb5, 0xb6, 0xb6, 0x0a, 0xde, 0x0a, 0xa7, 0x06,
0x00, 0x06, 0x00, 0x00, 0x06, 0x06, 0xed, 0x06, 0x8b, 0xbc, 0xf2, 0x0a, 0xb6, 0xb6, 0xb6, 0xb6,
0xb5, 0xb5, 0xb5, 0xb5, 0xb5, 0xb5, 0xb6, 0xb6, 0xb6, 0xb6, 0x0a, 0xf2, 0x1a, 0x8c, 0xec, 0x06,
0x06, 0x06, 0x00, 0x00, 0x04, 0x06, 0x04, 0x06, 0x04, 0xa7, 0xbc, 0x1a, 0x0a, 0x0a, 0x6a, 0xb6,
0x96, 0x0a, 0x0a, 0xf2, 0x0a, 0x87, 0x06, 0x04, 0x06, 0x04, 0x06, 0x00, 0x00, 0x06, 0x06, 0xed,
0x06, 0xed, 0x06, 0x8c, 0xb6, 0xf4, 0xf2, 0xd0, 0x09, 0xbc, 0x87, 0x03, 0x80, 0x2c, 0xde, 0xf4,
0x0a, 0x8b, 0x06, 0x06, 0xed, 0x06, 0xed, 0x06, 0x00, 0x00, 0x00, 0x06, 0x04, 0x06, 0x00, 0x06,
0x04, 0x6c, 0x87, 0x0a, 0xf4, 0xf4, 0xf2, 0xde, 0xbd, 0xbd, 0xde, 0xf2, 0xf4, 0xf4, 0x0a, 0xd0,
0x04, 0x06, 0x00, 0x06, 0x04, 0x06, 0x00, 0x06, 0x00, 0x00, 0x06, 0x06, 0xed, 0x06, 0x06, 0x06,
0xed, 0x06, 0x06, 0x6c, 0x8c, 0xb5, 0xbc, 0x0a, 0xde, 0xf2, 0xbd, 0x0a, 0xb5, 0x8c, 0x6c, 0x06,
0xed, 0x06, 0x06, 0x06, 0xed, 0x06, 0x06, 0x06, 0x00, 0x00, 0xe6, 0x04, 0x06, 0x86, 0x04, 0x6c,
0x04, 0x8b, 0x04, 0x6c, 0xe6, 0x04, 0x06, 0x82, 0x00, 0x00
};

uint8 decompressed_32x32x8[] =
{
0x04, 0x06, 0x04, 0x06, 0x04, 0x06, 0x04, 0x06, 0x04, 0x06, 0x04, 0x06, 0x04, 0x6c, 0x04, 0x8b,
0x04, 0x6c, 0x04, 0x06, 0x04, 0x06, 0x04, 0x06, 0x04, 0x06, 0x04, 0x06, 0x04, 0x06, 0x00, 0x00,
0x06, 0x06, 0xed, 0x06, 0x06, 0x06, 0xed, 0x06, 0x06, 0x6c, 0x8c, 0xb5, 0xbc, 0x0a, 0xde, 0xf2,
0xbd, 0x0a, 0xb5, 0x8c, 0x6c, 0x06, 0xed, 0x06, 0x06, 0x06, 0xed, 0x06, 0x06, 0x06, 0x00, 0x00,
0x00, 0x06, 0x04, 0x06, 0x00, 0x06, 0x04, 0x6c, 0x87, 0x0a, 0xf4, 0xf4, 0xf2, 0xde, 0xbd, 0xbd,
0xde, 0xf2, 0xf4, 0xf4, 0x0a, 0xd0, 0x04, 0x06, 0x00, 0x06, 0x04, 0x06, 0x00, 0x06, 0x00, 0x00,
0x06, 0x06, 0xed, 0x06, 0xed, 0x06, 0x8c, 0xb6, 0xf4, 0xf2, 0x0a, 0x0a, 0x0a, 0xb6, 0xb6, 0xb6,
0xb6, 0x0a, 0x0a, 0x0a, 0xde, 0xf4, 0x0a, 0x8b, 0x06, 0x06, 0xed, 0x06, 0xed, 0x06, 0x00, 0x00,
0x04, 0x06, 0x04, 0x06, 0x04, 0xa7, 0xbc, 0x1a, 0x0a, 0x0a, 0xb6, 0xb6, 0xb6, 0xb6, 0xb6, 0xb6,
0xb6, 0xb6, 0xb6, 0xb6, 0x0a, 0x0a, 0xf2, 0x0a, 0x87, 0x06, 0x04, 0x06, 0x04, 0x06, 0x00, 0x00,
0x06, 0x06, 0xed, 0x06, 0x8b, 0xbc, 0xf2, 0x0a, 0xb6, 0xb6, 0xb6, 0xb6, 0xb5, 0xb5, 0xb5, 0xb5,
0xb5, 0xb5, 0xb6, 0xb6, 0xb6, 0xb6, 0x0a, 0xf2, 0x1a, 0x8c, 0xec, 0x06, 0x06, 0x06, 0x00, 0x00,
0x00, 0x06, 0x04, 0x8b, 0xbc, 0x1a, 0x0a, 0xb6, 0xb6, 0xb5, 0xb5, 0xb5, 0xb5, 0xb5, 0xd0, 0xb5,
0xb5, 0xb5, 0xb5, 0xb5, 0xb5, 0xb6, 0xb6, 0x0a, 0xde, 0x0a, 0xa7, 0x06, 0x00, 0x06, 0x00, 0x00,
0xed, 0x06, 0x6e, 0xb5, 0x0a, 0xbc, 0xb6, 0xb5, 0xb5, 0xb5, 0xd0, 0xd0, 0xd0, 0xb5, 0xf4, 0xff,
0xf2, 0xd0, 0xd0, 0xd0, 0xb5, 0xb5, 0xb5, 0xb6, 0xbc, 0x0a, 0x0a, 0x8b, 0x06, 0x06, 0x00, 0x00,
0x04, 0x06, 0x87, 0x0a, 0xbc, 0xb6, 0xb5, 0xb5, 0xb5, 0xd0, 0xae, 0xae, 0xae, 0xb6, 0xff, 0xff,
0xff, 0xf2, 0xd0, 0xae, 0xd0, 0xb5, 0xb5, 0xb5, 0xb6, 0xbc, 0x1a, 0xb5, 0x04, 0x06, 0x00, 0x00,
0x06, 0x6c, 0xb5, 0x0a, 0xb6, 0xb5, 0xb5, 0xb5, 0xae, 0xae, 0xae, 0xae, 0xae, 0xbc, 0xff, 0xff,
0xff, 0xff, 0xf2, 0xae, 0xae, 0xae, 0xb5, 0xb5, 0xb5, 0xb6, 0x0a, 0x0a, 0x8b, 0x06, 0x00, 0x00,
0x00, 0x8b, 0x0a, 0xbc, 0xb5, 0xb5, 0xb5, 0xae, 0xae, 0xae, 0xae, 0xae, 0xae, 0xb6, 0xff, 0xff,
0xff, 0xff, 0xff, 0xf2, 0xae, 0xae, 0xae, 0xb5, 0xb5, 0xb5, 0xb6, 0x0a, 0x8c, 0x06, 0x00, 0x00,
0x06, 0xae, 0x0a, 0xb5, 0xb5, 0xb5, 0xd0, 0xae, 0xae, 0xae, 0xae, 0xae, 0xae, 0x8c, 0x0a, 0xff,
0xff, 0xff, 0xff, 0xff, 0xf2, 0xae, 0xae, 0xd0, 0xb5, 0xb5, 0xb5, 0x0a, 0xb5, 0x6c, 0x00, 0x00,
0x04, 0xae, 0x0a, 0xb5, 0xb5, 0xb5, 0xae, 0xae, 0xae, 0xae, 0xae, 0xae, 0xae, 0xae, 0x8c, 0x0a,
0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0xae, 0xae, 0xb5, 0xb5, 0xb5, 0xbc, 0xb5, 0x6c, 0x00, 0x00,
0x6c, 0xae, 0xbc, 0xb5, 0xb5, 0xae, 0xb5, 0xf3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0xae, 0xae, 0xb5, 0xb5, 0xbc, 0xb5, 0x66, 0x00, 0x00,
0x0b, 0xa7, 0xb5, 0xae, 0x8c, 0xa7, 0xf4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbd, 0xa7, 0x8c, 0xae, 0xb5, 0xae, 0x66, 0x00, 0x00,
0x13, 0x04, 0x66, 0x66, 0x66, 0x66, 0xf4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbd, 0x66, 0x66, 0x66, 0x66, 0xa7, 0x66, 0x00, 0x00,
0x60, 0xa7, 0x66, 0x60, 0x66, 0x66, 0x8c, 0xf1, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbd, 0x66, 0x66, 0x66, 0x60, 0x66, 0xa7, 0x66, 0x00, 0x00,
0x6c, 0x04, 0xa7, 0x60, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0xb6,
0xf5, 0xf5, 0xf5, 0xf5, 0xf5, 0xef, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0xa7, 0x66, 0x00, 0x00,
0x00, 0x60, 0xa7, 0x66, 0x66, 0x66, 0xa7, 0xa7, 0xa7, 0xa7, 0x8b, 0x8b, 0x8b, 0xa7, 0xb6, 0xf3,
0xf3, 0xf3, 0xf3, 0xf3, 0x07, 0x66, 0xa7, 0xa7, 0x66, 0x66, 0x66, 0xa7, 0xa7, 0x6c, 0x00, 0x00,
0x06, 0x66, 0xc8, 0xa7, 0x66, 0xa7, 0xa7, 0x8b, 0x8b, 0x8b, 0x8b, 0xad, 0x8b, 0x92, 0xf1, 0xf1,
0xf1, 0xf1, 0xf2, 0x07, 0xa7, 0xa7, 0x8b, 0xa7, 0xa7, 0x66, 0x66, 0xc8, 0x66, 0x06, 0x00, 0x00,
0x04, 0x6c, 0xa7, 0xad, 0xa7, 0xa7, 0x8b, 0xad, 0xad, 0xad, 0xad, 0xad, 0xad, 0xb5, 0xbd, 0xbd,
0xbd, 0xbd, 0xf0, 0x8b, 0x8b, 0xad, 0x8b, 0x8b, 0xa7, 0xa7, 0xc8, 0xc8, 0x60, 0x06, 0x00, 0x00,
0x06, 0x06, 0x66, 0xae, 0xad, 0x8b, 0xad, 0xad, 0xad, 0xad, 0xad, 0xb3, 0xad, 0xb5, 0x07, 0x07,
0x07, 0xf0, 0x8b, 0xad, 0xad, 0xad, 0xad, 0xad, 0x8b, 0xa7, 0xae, 0xa7, 0x6c, 0x06, 0x00, 0x00,
0x00, 0x06, 0x60, 0xa7, 0xb4, 0xad, 0xad, 0xad, 0xb3, 0xb3, 0xd4, 0xd4, 0xb3, 0x8c, 0xb6, 0x07,
0xb6, 0x8c, 0xb3, 0xd4, 0xb3, 0xb3, 0xad, 0xad, 0xad, 0xb4, 0xad, 0x66, 0x00, 0x06, 0x00, 0x00,
0xed, 0x06, 0xed, 0x66, 0xae, 0xd5, 0xad, 0xd4, 0xd4, 0xd5, 0xd5, 0xd5, 0xdb, 0xb4, 0xb4, 0xb4,
0xb4, 0xb4, 0xd5, 0xd5, 0xd5, 0xd4, 0xd4, 0xad, 0xd5, 0xb4, 0x0e, 0x06, 0x06, 0x06, 0x00, 0x00,
0x04, 0x06, 0x04, 0x06, 0x0b, 0xae, 0xdb, 0xd4, 0xd5, 0xdb, 0xdb, 0xdb, 0xdb, 0xdb, 0xdb, 0xdb,
0xdb, 0xdb, 0xdb, 0xdb, 0xdb, 0xd5, 0xd4, 0xdb, 0xb4, 0x66, 0x04, 0x06, 0x04, 0x06, 0x00, 0x00,
0x06, 0x06, 0xed, 0x06, 0x06, 0x0e, 0xae, 0xdc, 0xdb, 0xdb, 0xdb, 0xdb, 0xdb, 0xdb, 0xdc, 0xdc,
0xdb, 0xdb, 0xdb, 0xdb, 0xdb, 0xdb, 0xdc, 0xb4, 0x66, 0x6c, 0xed, 0x06, 0x06, 0x06, 0x00, 0x00,
0x00, 0x06, 0x04, 0x06, 0x00, 0x06, 0x0b, 0xae, 0xdc, 0xe9, 0xdc, 0xdc, 0xdc, 0xdc, 0xdc, 0xdc,
0xdc, 0xdc, 0xdc, 0xdc, 0xe9, 0xe9, 0xb4, 0x0e, 0x00, 0x06, 0x04, 0x06, 0x00, 0x06, 0x00, 0x00,
0x06, 0x06, 0xed, 0x06, 0xed, 0x06, 0xf8, 0x0e, 0x66, 0xb4, 0xdc, 0xe2, 0xe2, 0xe2, 0xe2, 0xe2,
0xe2, 0xe2, 0xe2, 0xdd, 0xb4, 0xa7, 0x16, 0x06, 0x06, 0x06, 0xed, 0x06, 0xed, 0x06, 0x00, 0x00,
0x04, 0x06, 0x04, 0x06, 0x04, 0x06, 0x04, 0x06, 0x60, 0x0e, 0x60, 0x8c, 0xb4, 0xb5, 0xdc, 0xdc,
0xbb, 0xb4, 0x8c, 0x66, 0x0b, 0x6c, 0x04, 0x06, 0x04, 0x06, 0x04, 0x06, 0x04, 0x06, 0x00, 0x00,
0x06, 0x06, 0xed, 0x06, 0x06, 0x06, 0xed, 0x06, 0x06, 0x06, 0xec, 0x6c, 0x0e, 0x0e, 0x44, 0x0e,
0x0e, 0x0e, 0x13, 0x06, 0x06, 0x06, 0xed, 0x06, 0x06, 0x06, 0xed, 0x06, 0x06, 0x06, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

uint8 compressed_16x1x16[] =
{
0x0c, 0x84, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

uint8 decompressed_16x1x16[] =
{
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

uint8 compressed_32x32x16[] =
{
0x1c, 0x84, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xca, 0xef, 0x1a, 0x8a,
0xcf, 0x12, 0x4e, 0x12, 0xce, 0x09, 0xaf, 0x09, 0x8f, 0x01, 0x8f, 0x01, 0xaf, 0x09, 0xce, 0x09,
0x2e, 0x12, 0xaf, 0x12, 0x2a, 0x0a, 0x8e, 0x8f, 0x12, 0xae, 0x09, 0xd2, 0x01, 0x9b, 0x23, 0x1d,
0x5d, 0x1e, 0x86, 0xbf, 0x9e, 0xdf, 0xa6, 0x5f, 0x8e, 0x7e, 0x6d, 0xfc, 0x2b, 0x16, 0x02, 0x8f,
0x09, 0x4f, 0x12, 0x11, 0x91, 0xce, 0x09, 0x17, 0x02, 0x1e, 0x55, 0x5f, 0xaf, 0xff, 0xcf, 0xff,
0xc7, 0xff, 0xbf, 0xff, 0xb7, 0xff, 0xb7, 0xff, 0xb7, 0xff, 0xc7, 0xff, 0xcf, 0xbf, 0xb7, 0xbe,
0x6d, 0xba, 0x02, 0xae, 0x09, 0xcf, 0x12, 0x0d, 0x94, 0xcf, 0x12, 0x6f, 0x01, 0x1d, 0x2c, 0x7f,
0x9f, 0xff, 0xaf, 0xff, 0x97, 0xdf, 0x87, 0xbf, 0x8f, 0xbf, 0x97, 0xbf, 0x9f, 0xbf, 0x9f, 0xbf,
0x97, 0xbf, 0x8f, 0xdf, 0x87, 0xff, 0x8f, 0xff, 0xa7, 0xdf, 0xa7, 0xdd, 0x3c, 0x4f, 0x01, 0x8f,
0x12, 0x0b, 0x96, 0xaf, 0x12, 0x2f, 0x01, 0xbd, 0x34, 0xbf, 0x8f, 0x5f, 0x77, 0x5f, 0x6f, 0x9f,
0x77, 0x9f, 0x7f, 0xbf, 0x87, 0xbf, 0x87, 0xbf, 0x87, 0xbf, 0x87, 0xbf, 0x87, 0xbf, 0x87, 0x9f,
0x7f, 0x7f, 0x7f, 0x5f, 0x6f, 0x3f, 0x6f, 0xbf, 0x87, 0xbf, 0x55, 0x72, 0x01, 0x6f, 0x12, 0x09,
0x98, 0xcf, 0x12, 0x4f, 0x01, 0xde, 0x34, 0xff, 0x6e, 0x5f, 0x4e, 0xbf, 0x5e, 0x1f, 0x67, 0x3f,
0x6f, 0x5f, 0x6f, 0x5f, 0x6f, 0x5f, 0x77, 0x5f, 0x77, 0x5f, 0x77, 0x5f, 0x77, 0x5f, 0x6f, 0x5f,
0x6f, 0x3f, 0x6f, 0x1f, 0x67, 0xdf, 0x5e, 0x3f, 0x4e, 0xbf, 0x66, 0xdf, 0x4d, 0x72, 0x01, 0xaf,
0x12, 0x08, 0x99, 0x8e, 0x09, 0xfc, 0x1b, 0x3f, 0x4e, 0x3e, 0x25, 0xff, 0x3d, 0x5f, 0x4e, 0x9f,
0x56, 0xbf, 0x5e, 0xdf, 0x66, 0xdf, 0x5e, 0x3c, 0x56, 0x79, 0x4d, 0x17, 0x4d, 0x99, 0x4d, 0x5d,
0x5e, 0xdf, 0x66, 0xbf, 0x5e, 0x9f, 0x56, 0x5f, 0x4e, 0xff, 0x3d, 0x1e, 0x25, 0xdf, 0x3d, 0xfe,
0x34, 0x2f, 0x01, 0xcf, 0x12, 0x06, 0x80, 0xa6, 0x0f, 0x0a, 0xba, 0x02, 0x5f, 0x35, 0x5d, 0x0c,
0xbd, 0x14, 0x5e, 0x2d, 0xbe, 0x3d, 0xff, 0x3d, 0x1f, 0x46, 0x3f, 0x46, 0x1e, 0x4e, 0xd7, 0x44,
0xb7, 0xa5, 0xf7, 0xbd, 0x97, 0x95, 0xb7, 0x44, 0x9c, 0x45, 0x1f, 0x46, 0xff, 0x3d, 0xbf, 0x3d,
0x5e, 0x2d, 0xbd, 0x1c, 0x3d, 0x04, 0x1e, 0x25, 0xbc, 0x13, 0xae, 0x09, 0xef, 0x1a, 0xef, 0x1a,
0x00, 0x00, 0x00, 0x00, 0xef, 0x1a, 0xaf, 0x12, 0x31, 0x01, 0x7d, 0x24, 0xdc, 0x03, 0xfc, 0x03,
0x5d, 0x0c, 0xbd, 0x14, 0x1e, 0x25, 0x3e, 0x2d, 0x7e, 0x35, 0x9e, 0x35, 0xfb, 0x34, 0x17, 0x6d,
0x18, 0xc6, 0x18, 0xc6, 0x18, 0xc6, 0xb8, 0xa5, 0x57, 0x2c, 0xfb, 0x2c, 0x5e, 0x2d, 0x1e, 0x25,
0xbd, 0x14, 0x5d, 0x0c, 0xfd, 0x03, 0x7a, 0x03, 0x9e, 0x24, 0xd6, 0x01, 0x6f, 0x12, 0xef, 0x1a,
0x00, 0x00, 0x00, 0x00, 0xef, 0x1a, 0x2f, 0x0a, 0x79, 0x02, 0xdd, 0x0b, 0xf8, 0x02, 0x9b, 0x03,
0xfd, 0x03, 0x3d, 0x0c, 0x7d, 0x14, 0xbd, 0x1c, 0xdd, 0x1c, 0xfe, 0x24, 0x7a, 0x1c, 0x18, 0x6d,
0x79, 0xce, 0x79, 0xce, 0x79, 0xce, 0x79, 0xce, 0xd9, 0xad, 0xd7, 0x23, 0x5b, 0x14, 0x7d, 0x14,
0x3d, 0x0c, 0xfd, 0x03, 0x9b, 0x03, 0x18, 0x03, 0x7b, 0x03, 0x1b, 0x0b, 0xaf, 0x09, 0xef, 0x1a,
0x00, 0x00, 0x00, 0x00, 0xef, 0x1a, 0x6f, 0x01, 0xda, 0x0a, 0x97, 0x02, 0x96, 0x02, 0x19, 0x03,
0x9b, 0x03, 0xfd, 0x03, 0x1d, 0x0c, 0x3d, 0x0c, 0x3d, 0x0c, 0x5d, 0x14, 0x1a, 0x14, 0xd8, 0x5c,
0xba, 0xd6, 0xba, 0xd6, 0xba, 0xd6, 0xdb, 0xd6, 0xdb, 0xde, 0x1a, 0xae, 0x77, 0x13, 0xba, 0x03,
0xfd, 0x03, 0x9b, 0x03, 0x19, 0x03, 0xb7, 0x02, 0x54, 0x02, 0x1b, 0x0b, 0x31, 0x01, 0xcf, 0x12,
0x00, 0x00, 0x00, 0x00, 0xaf, 0x12, 0x52, 0x01, 0xba, 0x02, 0xf3, 0x01, 0x34, 0x02, 0xb7, 0x02,
0xf8, 0x02, 0x7b, 0x03, 0xbc, 0x03, 0xdc, 0x03, 0xfd, 0x03, 0xfd, 0x03, 0x1d, 0x0c, 0x99, 0x03,
0x9a, 0x8d, 0x3c, 0xe7, 0x3c, 0xe7, 0x3c, 0xe7, 0x3c, 0xe7, 0x3c, 0xe7, 0x5b, 0xb6, 0x36, 0x0b,
0x39, 0x03, 0xf8, 0x02, 0xb7, 0x02, 0x34, 0x02, 0xd2, 0x01, 0x99, 0x02, 0x97, 0x01, 0x4f, 0x12,
0x00, 0x00, 0x00, 0x00, 0x6f, 0x12, 0x95, 0x01, 0x77, 0x02, 0xd2, 0x01, 0x13, 0x02, 0x55, 0x02,
0x75, 0x02, 0x74, 0x02, 0x94, 0x02, 0xb5, 0x02, 0xd6, 0x02, 0xf6, 0x02, 0xf6, 0x02, 0xf6, 0x02,
0x17, 0x03, 0xbb, 0x8d, 0x9e, 0xf7, 0x9e, 0xf7, 0x9e, 0xf7, 0x9e, 0xf7, 0x9e, 0xf7, 0x7c, 0xbe,
0xb4, 0x0a, 0x75, 0x02, 0x55, 0x02, 0xf3, 0x01, 0xd2, 0x01, 0x35, 0x02, 0xf8, 0x01, 0xef, 0x09,
0x00, 0x00, 0x00, 0x00, 0x0e, 0x0a, 0xf6, 0x01, 0x14, 0x02, 0xd2, 0x01, 0xf3, 0x01, 0xf2, 0x01,
0x75, 0x43, 0xfd, 0xce, 0x6e, 0xff, 0xff, 0x91, 0xbc, 0xc6, 0x32, 0x12, 0xf2, 0x01, 0xf3, 0x01,
0xd2, 0x01, 0xd2, 0x01, 0x17, 0x02, 0x8e, 0x09, 0x00, 0x00, 0x00, 0x00, 0xef, 0x09, 0xf5, 0x01,
0x14, 0x02, 0xd2, 0x01, 0xd2, 0x01, 0xb0, 0x01, 0x5e, 0xe7, 0x70, 0xff, 0xff, 0x90, 0x9c, 0xc6,
0xf0, 0x09, 0xd2, 0x01, 0xd2, 0x01, 0x13, 0x02, 0x16, 0x02, 0x8f, 0x01, 0x00, 0x00, 0x00, 0x00,
0x0f, 0x0a, 0x3a, 0x1b, 0x9d, 0x75, 0xdb, 0x54, 0xfa, 0x33, 0xd5, 0x12, 0x7e, 0xe7, 0x10, 0x91,
0xbd, 0xc6, 0xf6, 0x1a, 0xfa, 0x33, 0xdb, 0x5c, 0xbd, 0x7d, 0x3b, 0x3c, 0x90, 0x01, 0x00, 0x00,
0x00, 0x00, 0x2f, 0x0a, 0x5b, 0x4c, 0xde, 0xae, 0xdd, 0x85, 0x7c, 0x75, 0xfb, 0x5c, 0x5b, 0x75,
0x3e, 0xdf, 0x0e, 0x80, 0xc6, 0x1e, 0xd7, 0x9a, 0x54, 0xfb, 0x5c, 0x7c, 0x75, 0xdd, 0x85, 0xbe,
0xa6, 0xbd, 0x7d, 0xf0, 0x09, 0x00, 0x00, 0x00, 0x00, 0xb0, 0x12, 0x9b, 0x4c, 0x1f, 0xb7, 0xfd,
0x8d, 0x7c, 0x7d, 0x3c, 0x6d, 0xdc, 0x5c, 0x9c, 0x4c, 0x7c, 0x44, 0x7c, 0x3c, 0x5c, 0x34, 0x3c,
0x34, 0x3c, 0x2c, 0x3c, 0x2c, 0x1c, 0x24, 0x7e, 0xa6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0x3f, 0xd7, 0xdc, 0x54, 0xdc, 0x5c, 0x3c, 0x6d, 0x7c, 0x7d, 0xdc, 0x8d, 0xde,
0xb6, 0xdd, 0x85, 0x71, 0x0a, 0x00, 0x00, 0x00, 0x00, 0xcf, 0x12, 0x5a, 0x44, 0x5f, 0xc7, 0x1d,
0x96, 0xbc, 0x85, 0x5c, 0x75, 0xfb, 0x64, 0xbc, 0x54, 0x9b, 0x4c, 0x7c, 0x44, 0x5c, 0x3c, 0x5c,
0x34, 0x3c, 0x34, 0x3c, 0x2c, 0x7e, 0xae, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0x3f, 0xd7, 0xbc, 0x54, 0xbc, 0x54, 0x1c, 0x65, 0x5c, 0x75, 0xbc, 0x85, 0x1d, 0x96, 0x3f,
0xc7, 0xbd, 0x7d, 0x90, 0x12, 0x00, 0x00, 0x00, 0x00, 0xef, 0x1a, 0x57, 0x1b, 0x3f, 0xc7, 0x7d,
0xa6, 0xdc, 0x8d, 0x7c, 0x7d, 0x3c, 0x6d, 0xdc, 0x5c, 0xbb, 0x54, 0x7b, 0x4c, 0x7b, 0x44, 0x5b,
0x3c, 0x5c, 0x3c, 0xdd, 0x85, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f,
0xd7, 0xbc, 0x54, 0xbb, 0x54, 0xdb, 0x5c, 0x3c, 0x6d, 0x7c, 0x7d, 0xdc, 0x8d, 0x5d, 0xa6, 0x7f,
0xcf, 0x5a, 0x44, 0xef, 0x12, 0x00, 0x00, 0x00, 0x00, 0xef, 0x1a, 0xb1, 0x12, 0x3d, 0x96, 0x1e,
0xc7, 0xfc, 0x9d, 0xbc, 0x8d, 0x5c, 0x7d, 0x1b, 0x6d, 0xdb, 0x5c, 0x9b, 0x54, 0x7b, 0x4c, 0x7b,
0x44, 0x5b, 0x44, 0x1d, 0x9e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3e, 0xd7, 0xbb,
0x54, 0x9b, 0x54, 0xdb, 0x5c, 0x1c, 0x6d, 0x5c, 0x7d, 0xbc, 0x8d, 0x1d, 0x9e, 0xde, 0xbe, 0x1e,
0xbf, 0xf5, 0x0a, 0xef, 0x1a, 0x00, 0x00, 0x00, 0x00, 0xef, 0x1a, 0xcf, 0x12, 0xb8, 0x33, 0x7f,
0xd7, 0x7d, 0xae, 0xfc, 0x95, 0x9c, 0x85, 0x3b, 0x75, 0xfb, 0x64, 0xdb, 0x5c, 0x9b, 0x54, 0x9b,
0x54, 0x7b, 0x4c, 0xfd, 0x9d, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3e, 0xd7, 0xbb, 0x5c, 0x9b,
0x54, 0xdb, 0x5c, 0xfb, 0x64, 0x3b, 0x75, 0x9c, 0x85, 0xdc, 0x95, 0x7d, 0xae, 0x9f, 0xdf, 0x1b,
0x65, 0xd0, 0x12, 0xef, 0x1a, 0x00, 0x00, 0x00, 0x00, 0xef, 0x1a, 0xef, 0x1a, 0xd1, 0x12, 0xbd,
0x85, 0x5f, 0xd7, 0x5d, 0xae, 0xdc, 0x95, 0x7c, 0x85, 0x3b, 0x7d, 0x1b, 0x6d, 0xdb, 0x64, 0xbb,
0x5c, 0xbb, 0x5c, 0xfb, 0x64, 0x7f, 0xe7, 0xff, 0xff, 0x1e, 0xd7, 0xdb, 0x64, 0xbb, 0x5c, 0xdb,
0x64, 0xfb, 0x6c, 0x3b, 0x7d, 0x9c, 0x85, 0xdc, 0x95, 0x3d, 0xae, 0x3e, 0xcf, 0xbe, 0xb6, 0xf4,
0x0a, 0xef, 0x1a, 0xef, 0x1a, 0x00, 0x00, 0x00, 0x00, 0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0xd3,
0x0a, 0x5d, 0xa6, 0x5e, 0xd7, 0x5d, 0xae, 0xdc, 0x9d, 0x9c, 0x8d, 0x5b, 0x85, 0x3b, 0x7d, 0x1b,
0x75, 0xfb, 0x6c, 0xdb, 0x6c, 0xdb, 0x6c, 0x3b, 0x7d, 0xdb, 0x6c, 0xfb, 0x6c, 0x1b, 0x75, 0x3b,
0x7d, 0x5b, 0x85, 0x9c, 0x8d, 0xdc, 0x9d, 0x5d, 0xae, 0x3e, 0xd7, 0x3e, 0xcf, 0x36, 0x13, 0xef,
0x1a, 0x07, 0x98, 0xef, 0x1a, 0xd5, 0x0a, 0xbe, 0xb6, 0x5e, 0xdf, 0x5d, 0xae, 0xdc, 0x9d, 0xbc,
0x95, 0x7b, 0x8d, 0x5b, 0x85, 0x3b, 0x85, 0x3b, 0x7d, 0x1b, 0x7d, 0x1b, 0x7d, 0x3b, 0x7d, 0x3b,
0x85, 0x5b, 0x85, 0x9c, 0x8d, 0xbc, 0x95, 0xdc, 0x9d, 0x5d, 0xb6, 0x3e, 0xd7, 0x7f, 0xd7, 0x78,
0x23, 0xef, 0x12, 0x09, 0x97, 0xef, 0x1a, 0xd5, 0x0a, 0x7e, 0xae, 0x5e, 0xdf, 0x7d, 0xbe, 0x1c,
0xae, 0xdc, 0xa5, 0xbc, 0x9d, 0x9c, 0x95, 0x9b, 0x95, 0x9c, 0x8d, 0x9c, 0x8d, 0x9b, 0x95, 0x9c,
0x95, 0xbc, 0x9d, 0xdc, 0xa5, 0x1c, 0xae, 0x7d, 0xbe, 0x5e, 0xdf, 0x3e, 0xcf, 0x77, 0x23, 0xcf,
0x12, 0xef, 0x1a, 0x0a, 0x95, 0xef, 0x1a, 0xb3, 0x0a, 0xdd, 0x95, 0x9f, 0xe7, 0x1e, 0xd7, 0x9d,
0xbe, 0x3d, 0xae, 0x1c, 0xae, 0xfc, 0xa5, 0xdc, 0xa5, 0xdc, 0xa5, 0xfc, 0xa5, 0x1c, 0xae, 0x3d,
0xae, 0x7d, 0xbe, 0x1e, 0xd7, 0xbf, 0xef, 0x7d, 0xae, 0xf5, 0x12, 0xef, 0x12, 0xef, 0x1a, 0x0c,
0x93, 0xef, 0x1a, 0x90, 0x12, 0xd8, 0x3b, 0x7d, 0xae, 0x7f, 0xe7, 0x7f, 0xe7, 0x1e, 0xd7, 0xde,
0xce, 0xbd, 0xc6, 0xbd, 0xc6, 0xde, 0xce, 0x1e, 0xd7, 0x7f, 0xe7, 0x9f, 0xef, 0xde, 0xc6, 0x7a,
0x54, 0xb2, 0x0a, 0xef, 0x1a, 0xef, 0x1a, 0x0e, 0x8f, 0xef, 0x1a, 0xcf, 0x12, 0xb0, 0x12, 0x56,
0x1b, 0xda, 0x64, 0x1d, 0xa6, 0xbe, 0xbe, 0xfe, 0xce, 0xfe, 0xce, 0xde, 0xc6, 0x5d, 0xae, 0x3b,
0x7d, 0x97, 0x2b, 0xb2, 0x0a, 0xcf, 0x12, 0x68, 0xef, 0x1a, 0x0a, 0x8b, 0xef, 0x1a, 0xef, 0x1a,
0xef, 0x1a, 0xcf, 0x12, 0xb0, 0x12, 0x91, 0x0a, 0xb3, 0x0a, 0xb3, 0x0a, 0x91, 0x0a, 0xb0, 0x12,
0xcf, 0x12, 0x69, 0xef, 0x1a, 0x84, 0xef, 0x1a, 0xef, 0x1a, 0x00, 0x00, 0x00, 0x00
};

uint8 decompressed_32x32x16[] =
{
0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a,
0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0xcf, 0x12, 0xb0, 0x12, 0x91, 0x0a, 0xb3, 0x0a, 0xb3, 0x0a,
0x91, 0x0a, 0xb0, 0x12, 0xcf, 0x12, 0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a,
0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0x00, 0x00, 0x00, 0x00,
0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a,
0xcf, 0x12, 0xb0, 0x12, 0x56, 0x1b, 0xda, 0x64, 0x1d, 0xa6, 0xbe, 0xbe, 0xfe, 0xce, 0xfe, 0xce,
0xde, 0xc6, 0x5d, 0xae, 0x3b, 0x7d, 0x97, 0x2b, 0xb2, 0x0a, 0xcf, 0x12, 0xef, 0x1a, 0xef, 0x1a,
0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0x00, 0x00, 0x00, 0x00,
0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0x90, 0x12,
0xd8, 0x3b, 0x7d, 0xae, 0x7f, 0xe7, 0x7f, 0xe7, 0x1e, 0xd7, 0xde, 0xce, 0xbd, 0xc6, 0xbd, 0xc6,
0xde, 0xce, 0x1e, 0xd7, 0x7f, 0xe7, 0x9f, 0xef, 0xde, 0xc6, 0x7a, 0x54, 0xb2, 0x0a, 0xef, 0x1a,
0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0x00, 0x00, 0x00, 0x00,
0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0xb3, 0x0a, 0xdd, 0x95,
0x9f, 0xe7, 0x1e, 0xd7, 0x9d, 0xbe, 0x3d, 0xae, 0x1c, 0xae, 0xfc, 0xa5, 0xdc, 0xa5, 0xdc, 0xa5,
0xfc, 0xa5, 0x1c, 0xae, 0x3d, 0xae, 0x7d, 0xbe, 0x1e, 0xd7, 0xbf, 0xef, 0x7d, 0xae, 0xf5, 0x12,
0xef, 0x12, 0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0x00, 0x00, 0x00, 0x00,
0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0xd5, 0x0a, 0x7e, 0xae, 0x5e, 0xdf,
0x7d, 0xbe, 0x1c, 0xae, 0xdc, 0xa5, 0xbc, 0x9d, 0x9c, 0x95, 0x9b, 0x95, 0x9c, 0x8d, 0x9c, 0x8d,
0x9b, 0x95, 0x9c, 0x95, 0xbc, 0x9d, 0xdc, 0xa5, 0x1c, 0xae, 0x7d, 0xbe, 0x5e, 0xdf, 0x3e, 0xcf,
0x77, 0x23, 0xcf, 0x12, 0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0x00, 0x00, 0x00, 0x00,
0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0xd5, 0x0a, 0xbe, 0xb6, 0x5e, 0xdf, 0x5d, 0xae,
0xdc, 0x9d, 0xbc, 0x95, 0x7b, 0x8d, 0x5b, 0x85, 0x3b, 0x85, 0x3b, 0x7d, 0x1b, 0x7d, 0x1b, 0x7d,
0x3b, 0x7d, 0x3b, 0x85, 0x5b, 0x85, 0x9c, 0x8d, 0xbc, 0x95, 0xdc, 0x9d, 0x5d, 0xb6, 0x3e, 0xd7,
0x7f, 0xd7, 0x78, 0x23, 0xef, 0x12, 0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0x00, 0x00, 0x00, 0x00,
0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0xd3, 0x0a, 0x5d, 0xa6, 0x5e, 0xd7, 0x5d, 0xae, 0xdc, 0x9d,
0x9c, 0x8d, 0x5b, 0x85, 0x3b, 0x7d, 0x1b, 0x75, 0xfb, 0x6c, 0xdb, 0x6c, 0xdb, 0x6c, 0x3b, 0x7d,
0xdb, 0x6c, 0xfb, 0x6c, 0x1b, 0x75, 0x3b, 0x7d, 0x5b, 0x85, 0x9c, 0x8d, 0xdc, 0x9d, 0x5d, 0xae,
0x3e, 0xd7, 0x3e, 0xcf, 0x36, 0x13, 0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0x00, 0x00, 0x00, 0x00,
0xef, 0x1a, 0xef, 0x1a, 0xd1, 0x12, 0xbd, 0x85, 0x5f, 0xd7, 0x5d, 0xae, 0xdc, 0x95, 0x7c, 0x85,
0x3b, 0x7d, 0x1b, 0x6d, 0xdb, 0x64, 0xbb, 0x5c, 0xbb, 0x5c, 0xfb, 0x64, 0x7f, 0xe7, 0xff, 0xff,
0x1e, 0xd7, 0xdb, 0x64, 0xbb, 0x5c, 0xdb, 0x64, 0xfb, 0x6c, 0x3b, 0x7d, 0x9c, 0x85, 0xdc, 0x95,
0x3d, 0xae, 0x3e, 0xcf, 0xbe, 0xb6, 0xf4, 0x0a, 0xef, 0x1a, 0xef, 0x1a, 0x00, 0x00, 0x00, 0x00,
0xef, 0x1a, 0xcf, 0x12, 0xb8, 0x33, 0x7f, 0xd7, 0x7d, 0xae, 0xfc, 0x95, 0x9c, 0x85, 0x3b, 0x75,
0xfb, 0x64, 0xdb, 0x5c, 0x9b, 0x54, 0x9b, 0x54, 0x7b, 0x4c, 0xfd, 0x9d, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0x3e, 0xd7, 0xbb, 0x5c, 0x9b, 0x54, 0xdb, 0x5c, 0xfb, 0x64, 0x3b, 0x75, 0x9c, 0x85,
0xdc, 0x95, 0x7d, 0xae, 0x9f, 0xdf, 0x1b, 0x65, 0xd0, 0x12, 0xef, 0x1a, 0x00, 0x00, 0x00, 0x00,
0xef, 0x1a, 0xb1, 0x12, 0x3d, 0x96, 0x1e, 0xc7, 0xfc, 0x9d, 0xbc, 0x8d, 0x5c, 0x7d, 0x1b, 0x6d,
0xdb, 0x5c, 0x9b, 0x54, 0x7b, 0x4c, 0x7b, 0x44, 0x5b, 0x44, 0x1d, 0x9e, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0x3e, 0xd7, 0xbb, 0x54, 0x9b, 0x54, 0xdb, 0x5c, 0x1c, 0x6d, 0x5c, 0x7d,
0xbc, 0x8d, 0x1d, 0x9e, 0xde, 0xbe, 0x1e, 0xbf, 0xf5, 0x0a, 0xef, 0x1a, 0x00, 0x00, 0x00, 0x00,
0xef, 0x1a, 0x57, 0x1b, 0x3f, 0xc7, 0x7d, 0xa6, 0xdc, 0x8d, 0x7c, 0x7d, 0x3c, 0x6d, 0xdc, 0x5c,
0xbb, 0x54, 0x7b, 0x4c, 0x7b, 0x44, 0x5b, 0x3c, 0x5c, 0x3c, 0xdd, 0x85, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 0xd7, 0xbc, 0x54, 0xbb, 0x54, 0xdb, 0x5c, 0x3c, 0x6d,
0x7c, 0x7d, 0xdc, 0x8d, 0x5d, 0xa6, 0x7f, 0xcf, 0x5a, 0x44, 0xef, 0x12, 0x00, 0x00, 0x00, 0x00,
0xcf, 0x12, 0x5a, 0x44, 0x5f, 0xc7, 0x1d, 0x96, 0xbc, 0x85, 0x5c, 0x75, 0xfb, 0x64, 0xbc, 0x54,
0x9b, 0x4c, 0x7c, 0x44, 0x5c, 0x3c, 0x5c, 0x34, 0x3c, 0x34, 0x3c, 0x2c, 0x7e, 0xae, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 0xd7, 0xbc, 0x54, 0xbc, 0x54, 0x1c, 0x65,
0x5c, 0x75, 0xbc, 0x85, 0x1d, 0x96, 0x3f, 0xc7, 0xbd, 0x7d, 0x90, 0x12, 0x00, 0x00, 0x00, 0x00,
0xb0, 0x12, 0x9b, 0x4c, 0x1f, 0xb7, 0xfd, 0x8d, 0x7c, 0x7d, 0x3c, 0x6d, 0xdc, 0x5c, 0x9c, 0x4c,
0x7c, 0x44, 0x7c, 0x3c, 0x5c, 0x34, 0x3c, 0x34, 0x3c, 0x2c, 0x3c, 0x2c, 0x1c, 0x24, 0x7e, 0xa6,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 0xd7, 0xdc, 0x54, 0xdc, 0x5c,
0x3c, 0x6d, 0x7c, 0x7d, 0xdc, 0x8d, 0xde, 0xb6, 0xdd, 0x85, 0x71, 0x0a, 0x00, 0x00, 0x00, 0x00,
0x2f, 0x0a, 0x5b, 0x4c, 0xde, 0xae, 0xdd, 0x85, 0x7c, 0x75, 0xfb, 0x5c, 0x5b, 0x75, 0x3e, 0xdf,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x1e, 0xd7, 0x9a, 0x54,
0xfb, 0x5c, 0x7c, 0x75, 0xdd, 0x85, 0xbe, 0xa6, 0xbd, 0x7d, 0xf0, 0x09, 0x00, 0x00, 0x00, 0x00,
0x0f, 0x0a, 0x3a, 0x1b, 0x9d, 0x75, 0xdb, 0x54, 0xfa, 0x33, 0xd5, 0x12, 0x7e, 0xe7, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbd, 0xc6,
0xf6, 0x1a, 0xfa, 0x33, 0xdb, 0x5c, 0xbd, 0x7d, 0x3b, 0x3c, 0x90, 0x01, 0x00, 0x00, 0x00, 0x00,
0xef, 0x09, 0xf5, 0x01, 0x14, 0x02, 0xd2, 0x01, 0xd2, 0x01, 0xb0, 0x01, 0x5e, 0xe7, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x9c, 0xc6,
0xf0, 0x09, 0xd2, 0x01, 0xd2, 0x01, 0x13, 0x02, 0x16, 0x02, 0x8f, 0x01, 0x00, 0x00, 0x00, 0x00,
0x0e, 0x0a, 0xf6, 0x01, 0x14, 0x02, 0xd2, 0x01, 0xf3, 0x01, 0xf2, 0x01, 0x75, 0x43, 0xfd, 0xce,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xc6, 0x32, 0x12,
0xf2, 0x01, 0xf3, 0x01, 0xd2, 0x01, 0xd2, 0x01, 0x17, 0x02, 0x8e, 0x09, 0x00, 0x00, 0x00, 0x00,
0x6f, 0x12, 0x95, 0x01, 0x77, 0x02, 0xd2, 0x01, 0x13, 0x02, 0x55, 0x02, 0x75, 0x02, 0x74, 0x02,
0x94, 0x02, 0xb5, 0x02, 0xd6, 0x02, 0xf6, 0x02, 0xf6, 0x02, 0xf6, 0x02, 0x17, 0x03, 0xbb, 0x8d,
0x9e, 0xf7, 0x9e, 0xf7, 0x9e, 0xf7, 0x9e, 0xf7, 0x9e, 0xf7, 0x7c, 0xbe, 0xb4, 0x0a, 0x75, 0x02,
0x55, 0x02, 0xf3, 0x01, 0xd2, 0x01, 0x35, 0x02, 0xf8, 0x01, 0xef, 0x09, 0x00, 0x00, 0x00, 0x00,
0xaf, 0x12, 0x52, 0x01, 0xba, 0x02, 0xf3, 0x01, 0x34, 0x02, 0xb7, 0x02, 0xf8, 0x02, 0x7b, 0x03,
0xbc, 0x03, 0xdc, 0x03, 0xfd, 0x03, 0xfd, 0x03, 0x1d, 0x0c, 0x99, 0x03, 0x9a, 0x8d, 0x3c, 0xe7,
0x3c, 0xe7, 0x3c, 0xe7, 0x3c, 0xe7, 0x3c, 0xe7, 0x5b, 0xb6, 0x36, 0x0b, 0x39, 0x03, 0xf8, 0x02,
0xb7, 0x02, 0x34, 0x02, 0xd2, 0x01, 0x99, 0x02, 0x97, 0x01, 0x4f, 0x12, 0x00, 0x00, 0x00, 0x00,
0xef, 0x1a, 0x6f, 0x01, 0xda, 0x0a, 0x97, 0x02, 0x96, 0x02, 0x19, 0x03, 0x9b, 0x03, 0xfd, 0x03,
0x1d, 0x0c, 0x3d, 0x0c, 0x3d, 0x0c, 0x5d, 0x14, 0x1a, 0x14, 0xd8, 0x5c, 0xba, 0xd6, 0xba, 0xd6,
0xba, 0xd6, 0xdb, 0xd6, 0xdb, 0xde, 0x1a, 0xae, 0x77, 0x13, 0xba, 0x03, 0xfd, 0x03, 0x9b, 0x03,
0x19, 0x03, 0xb7, 0x02, 0x54, 0x02, 0x1b, 0x0b, 0x31, 0x01, 0xcf, 0x12, 0x00, 0x00, 0x00, 0x00,
0xef, 0x1a, 0x2f, 0x0a, 0x79, 0x02, 0xdd, 0x0b, 0xf8, 0x02, 0x9b, 0x03, 0xfd, 0x03, 0x3d, 0x0c,
0x7d, 0x14, 0xbd, 0x1c, 0xdd, 0x1c, 0xfe, 0x24, 0x7a, 0x1c, 0x18, 0x6d, 0x79, 0xce, 0x79, 0xce,
0x79, 0xce, 0x79, 0xce, 0xd9, 0xad, 0xd7, 0x23, 0x5b, 0x14, 0x7d, 0x14, 0x3d, 0x0c, 0xfd, 0x03,
0x9b, 0x03, 0x18, 0x03, 0x7b, 0x03, 0x1b, 0x0b, 0xaf, 0x09, 0xef, 0x1a, 0x00, 0x00, 0x00, 0x00,
0xef, 0x1a, 0xaf, 0x12, 0x31, 0x01, 0x7d, 0x24, 0xdc, 0x03, 0xfc, 0x03, 0x5d, 0x0c, 0xbd, 0x14,
0x1e, 0x25, 0x3e, 0x2d, 0x7e, 0x35, 0x9e, 0x35, 0xfb, 0x34, 0x17, 0x6d, 0x18, 0xc6, 0x18, 0xc6,
0x18, 0xc6, 0xb8, 0xa5, 0x57, 0x2c, 0xfb, 0x2c, 0x5e, 0x2d, 0x1e, 0x25, 0xbd, 0x14, 0x5d, 0x0c,
0xfd, 0x03, 0x7a, 0x03, 0x9e, 0x24, 0xd6, 0x01, 0x6f, 0x12, 0xef, 0x1a, 0x00, 0x00, 0x00, 0x00,
0xef, 0x1a, 0xef, 0x1a, 0x0f, 0x0a, 0xba, 0x02, 0x5f, 0x35, 0x5d, 0x0c, 0xbd, 0x14, 0x5e, 0x2d,
0xbe, 0x3d, 0xff, 0x3d, 0x1f, 0x46, 0x3f, 0x46, 0x1e, 0x4e, 0xd7, 0x44, 0xb7, 0xa5, 0xf7, 0xbd,
0x97, 0x95, 0xb7, 0x44, 0x9c, 0x45, 0x1f, 0x46, 0xff, 0x3d, 0xbf, 0x3d, 0x5e, 0x2d, 0xbd, 0x1c,
0x3d, 0x04, 0x1e, 0x25, 0xbc, 0x13, 0xae, 0x09, 0xef, 0x1a, 0xef, 0x1a, 0x00, 0x00, 0x00, 0x00,
0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0x8e, 0x09, 0xfc, 0x1b, 0x3f, 0x4e, 0x3e, 0x25, 0xff, 0x3d,
0x5f, 0x4e, 0x9f, 0x56, 0xbf, 0x5e, 0xdf, 0x66, 0xdf, 0x5e, 0x3c, 0x56, 0x79, 0x4d, 0x17, 0x4d,
0x99, 0x4d, 0x5d, 0x5e, 0xdf, 0x66, 0xbf, 0x5e, 0x9f, 0x56, 0x5f, 0x4e, 0xff, 0x3d, 0x1e, 0x25,
0xdf, 0x3d, 0xfe, 0x34, 0x2f, 0x01, 0xcf, 0x12, 0xef, 0x1a, 0xef, 0x1a, 0x00, 0x00, 0x00, 0x00,
0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0xcf, 0x12, 0x4f, 0x01, 0xde, 0x34, 0xff, 0x6e, 0x5f, 0x4e,
0xbf, 0x5e, 0x1f, 0x67, 0x3f, 0x6f, 0x5f, 0x6f, 0x5f, 0x6f, 0x5f, 0x77, 0x5f, 0x77, 0x5f, 0x77,
0x5f, 0x77, 0x5f, 0x6f, 0x5f, 0x6f, 0x3f, 0x6f, 0x1f, 0x67, 0xdf, 0x5e, 0x3f, 0x4e, 0xbf, 0x66,
0xdf, 0x4d, 0x72, 0x01, 0xaf, 0x12, 0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0x00, 0x00, 0x00, 0x00,
0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0xaf, 0x12, 0x2f, 0x01, 0xbd, 0x34, 0xbf, 0x8f,
0x5f, 0x77, 0x5f, 0x6f, 0x9f, 0x77, 0x9f, 0x7f, 0xbf, 0x87, 0xbf, 0x87, 0xbf, 0x87, 0xbf, 0x87,
0xbf, 0x87, 0xbf, 0x87, 0x9f, 0x7f, 0x7f, 0x7f, 0x5f, 0x6f, 0x3f, 0x6f, 0xbf, 0x87, 0xbf, 0x55,
0x72, 0x01, 0x6f, 0x12, 0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0x00, 0x00, 0x00, 0x00,
0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0xcf, 0x12, 0x6f, 0x01, 0x1d, 0x2c,
0x7f, 0x9f, 0xff, 0xaf, 0xff, 0x97, 0xdf, 0x87, 0xbf, 0x8f, 0xbf, 0x97, 0xbf, 0x9f, 0xbf, 0x9f,
0xbf, 0x97, 0xbf, 0x8f, 0xdf, 0x87, 0xff, 0x8f, 0xff, 0xa7, 0xdf, 0xa7, 0xdd, 0x3c, 0x4f, 0x01,
0x8f, 0x12, 0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0x00, 0x00, 0x00, 0x00,
0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0xce, 0x09,
0x17, 0x02, 0x1e, 0x55, 0x5f, 0xaf, 0xff, 0xcf, 0xff, 0xc7, 0xff, 0xbf, 0xff, 0xb7, 0xff, 0xb7,
0xff, 0xb7, 0xff, 0xc7, 0xff, 0xcf, 0xbf, 0xb7, 0xbe, 0x6d, 0xba, 0x02, 0xae, 0x09, 0xcf, 0x12,
0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0x00, 0x00, 0x00, 0x00,
0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a,
0x8f, 0x12, 0xae, 0x09, 0xd2, 0x01, 0x9b, 0x23, 0x1d, 0x5d, 0x1e, 0x86, 0xbf, 0x9e, 0xdf, 0xa6,
0x5f, 0x8e, 0x7e, 0x6d, 0xfc, 0x2b, 0x16, 0x02, 0x8f, 0x09, 0x4f, 0x12, 0xef, 0x1a, 0xef, 0x1a,
0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0x00, 0x00, 0x00, 0x00,
0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a,
0xef, 0x1a, 0xef, 0x1a, 0xcf, 0x12, 0x4e, 0x12, 0xce, 0x09, 0xaf, 0x09, 0x8f, 0x01, 0x8f, 0x01,
0xaf, 0x09, 0xce, 0x09, 0x2e, 0x12, 0xaf, 0x12, 0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a,
0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0xef, 0x1a, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

uint8 compressed_16x1x24[] =
{
0x0c, 0x84, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

uint8 decompressed_16x1x24[] =
{
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

uint8 compressed_32x32x24[] =
{
0x84, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0x38, 0x8a, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0xc0, 0xc0, 0xc0, 0x1a, 0x87, 0xc0,
0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xc0, 0xc0, 0x80, 0x80,
0x00, 0x80, 0x80, 0x80, 0x1a, 0x87, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0xc0, 0xc0, 0xc0, 0x1d, 0x84, 0xff, 0xff, 0xff,
0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0xc0, 0xc0, 0xc0, 0x18, 0x88, 0xc0, 0xc0, 0xc0, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xc0, 0xc0, 0x80, 0x80, 0x00,
0x80, 0x80, 0x80, 0x17, 0x8a, 0xff, 0xff, 0xff, 0xc0, 0xc0, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00,
0xc0, 0xc0, 0xc0, 0x1d, 0x83, 0xc0, 0xc0, 0xc0, 0x80, 0x80, 0x00, 0x80, 0x80, 0x00, 0x18, 0x89,
0xc0, 0xc0, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0xc0, 0xc0, 0xc0, 0x16, 0x8a, 0xff, 0xff, 0xff,
0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xc0, 0xc0, 0xc0, 0x80, 0x80, 0x00, 0x80, 0x80, 0x00, 0x17, 0x8a, 0xff, 0xff, 0xff,
0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0xc0, 0xc0, 0xc0, 0x17, 0x97, 0xff, 0xff, 0xff,
0x80, 0x80, 0x80, 0xc0, 0xc0, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,
0xc0, 0xc0, 0x80, 0x80, 0x00, 0x80, 0x80, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xc0, 0xc0, 0xc0, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0x80, 0x80, 0x80, 0xc0,
0xc0, 0xc0, 0x6b, 0xff, 0xff, 0xff, 0x01, 0x95, 0x80, 0x80, 0x80, 0xc0, 0xc0, 0xc0, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0x80, 0x80, 0x00, 0x80, 0x80, 0x00, 0xc0, 0xc0, 0xc0, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xc0, 0xc0, 0xc0, 0x80, 0x80, 0x00, 0xc0, 0xc0, 0xc0, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x6c, 0xff, 0xff, 0xff, 0x86, 0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0x80, 0x80, 0x00, 0xc0, 0xc0, 0xc0, 0x6d, 0xff,
0xff, 0xff, 0x01, 0x81, 0xc0, 0xc0, 0xc0, 0x6d, 0xff, 0xff, 0xff, 0x88, 0xc0, 0xc0, 0xc0, 0x80,
0x80, 0x80, 0x80, 0x80, 0x00, 0x80, 0x80, 0x00, 0x80, 0x80, 0x00, 0x80, 0x80, 0x80, 0xc0, 0xc0,
0xc0, 0xc0, 0xc0, 0xc0, 0x09, 0x82, 0xc0, 0xc0, 0xc0, 0x80, 0x80, 0x80, 0x6f, 0xff, 0xff, 0xff,
0x02, 0x86, 0xc0, 0xc0, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
0xc0, 0xc0, 0xc0, 0xc0, 0x07, 0x82, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0x0f, 0x91, 0x80, 0x80,
0x80, 0x80, 0x80, 0x00, 0xc0, 0xc0, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xc0, 0xc0, 0xc0, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0xc0, 0xc0, 0xc0, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xc0, 0xc0, 0x80, 0x80, 0x00, 0x80, 0x80,
0x80, 0x0f, 0x81, 0xc0, 0xc0, 0xc0, 0x06, 0x8a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x80,
0x80, 0x80, 0x80, 0x00, 0xc0, 0xc0, 0xc0, 0xff, 0xff, 0xff, 0xc0, 0xc0, 0xc0, 0x80, 0x80, 0x00,
0x80, 0x80, 0x00, 0xc0, 0xc0, 0xc0, 0x0d, 0x85, 0x80, 0x80, 0x80, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
0xc0, 0x80, 0x80, 0x00, 0x80, 0x80, 0x80, 0x06, 0x87, 0xc0, 0xc0, 0xc0, 0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0xc0, 0xc0, 0xc0, 0x80, 0x80, 0x00, 0x80, 0x80, 0x00, 0xc0, 0xc0, 0xc0, 0x6e, 0xff,
0xff, 0xff, 0x91, 0x80, 0x80, 0x00, 0x80, 0x80, 0x80, 0xff, 0xff, 0xff, 0x80, 0x80, 0x00, 0x80,
0x80, 0x00, 0xc0, 0xc0, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xc0, 0xc0, 0x80, 0x80, 0x00,
0x80, 0x80, 0x00, 0xc0, 0xc0, 0xc0, 0x6e, 0xff, 0xff, 0xff, 0x85, 0xc0, 0xc0, 0xc0, 0x80, 0x80,
0x00, 0xc0, 0xc0, 0xc0, 0xff, 0xff, 0xff, 0x80, 0x80, 0x80, 0x09, 0x83, 0x80, 0x80, 0x00, 0x80,
0x80, 0x00, 0xc0, 0xc0, 0xc0, 0x6f, 0xff, 0xff, 0xff, 0x01, 0x84, 0x80, 0x80, 0x80, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xc0, 0xc0, 0xc0, 0x08, 0x83, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0xc0,
0xc0, 0xc0, 0x70, 0xff, 0xff, 0xff, 0x06, 0x81, 0x80, 0x80, 0x80, 0x06, 0x82, 0x80, 0x80, 0x00,
0xc0, 0xc0, 0xc0, 0x71, 0xff, 0xff, 0xff, 0x13, 0x83, 0xc0, 0xc0, 0xc0, 0x80, 0x80, 0x00, 0xc0,
0xc0, 0xc0, 0x0e, 0x83, 0xff, 0xff, 0xff, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0x06, 0x8a, 0x80,
0x80, 0x80, 0xc0, 0xc0, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0xc0, 0xc0, 0xc0, 0x16, 0x8a, 0xc0,
0xc0, 0xc0, 0x80, 0x80, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x6a, 0xff, 0xff,
0xff, 0x0c, 0x89, 0xff, 0xff, 0xff, 0xc0, 0xc0, 0xc0, 0x80, 0x80, 0x80, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xc0, 0xc0, 0x18, 0x89,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x80, 0x80, 0xc0, 0xc0, 0xc0, 0x0a, 0x86, 0xc0, 0xc0, 0xc0,
0xc0, 0xc0, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x6b,
0xff, 0xff, 0xff, 0x01, 0x82, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0x6d, 0xff, 0xff, 0xff, 0x04,
0x81, 0xc0, 0xc0, 0xc0, 0x7c, 0xff, 0xff, 0xff, 0x83, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0x80,
0x80, 0x80, 0x60, 0x0e, 0xff, 0xff, 0xff, 0x84, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff
};

uint8 decompressed_32x32x24[] =
{
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0x80, 0x80, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xc0,
0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x80, 0x80, 0xc0, 0xc0, 0xc0, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xc0,
0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x80, 0x80, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x80, 0x80, 0xc0, 0xc0, 0xc0, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x80, 0x80, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xc0, 0xc0, 0xc0, 0x80, 0x80, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xc0, 0xc0, 0x80, 0x80, 0x80, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xc0, 0xc0, 0x80, 0x80, 0x80, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,
0xc0, 0xc0, 0x80, 0x80, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xc0, 0xc0, 0x80, 0x80, 0x80, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80,
0x80, 0x80, 0xc0, 0xc0, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0xc0, 0xc0, 0xc0, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xc0, 0xc0, 0x80, 0x80, 0x80, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xc0, 0xc0, 0xc0, 0x80, 0x80, 0x00, 0x80, 0x80, 0x80, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80,
0x80, 0x00, 0xc0, 0xc0, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xc0, 0xc0, 0xc0, 0x80, 0x80, 0x00, 0xc0, 0xc0, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xc0, 0xc0, 0x80, 0x80, 0x80, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xc0, 0xc0, 0xc0, 0x80, 0x80, 0x00, 0x80, 0x80, 0x80, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80,
0x80, 0x00, 0xc0, 0xc0, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xc0, 0xc0, 0x80, 0x80, 0x80, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xc0, 0xc0, 0xc0, 0x80, 0x80, 0x00, 0xc0, 0xc0, 0xc0, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80,
0x80, 0x80, 0x80, 0x80, 0x00, 0xc0, 0xc0, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xc0, 0xc0, 0x80, 0x80, 0x00, 0xc0, 0xc0,
0xc0, 0xff, 0xff, 0xff, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0xc0, 0xc0, 0xc0, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0x80, 0x80, 0x00, 0x80, 0x80, 0x00, 0xc0, 0xc0, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x80, 0x00, 0x80, 0x80,
0x80, 0xff, 0xff, 0xff, 0x80, 0x80, 0x00, 0x80, 0x80, 0x00, 0xc0, 0xc0, 0xc0, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xc0, 0xc0, 0xc0, 0x80, 0x80, 0x00, 0x80, 0x80, 0x00, 0xc0, 0xc0, 0xc0, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x80, 0x80, 0xc0, 0xc0,
0xc0, 0xc0, 0xc0, 0xc0, 0x80, 0x80, 0x00, 0x80, 0x80, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xc0, 0xc0, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0xc0, 0xc0, 0xc0, 0x80, 0x80, 0x00, 0x80, 0x80, 0x00, 0xc0, 0xc0,
0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xc0, 0xc0, 0xc0, 0x80, 0x80, 0x00, 0xc0, 0xc0, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x80, 0x80, 0x80,
0x80, 0x00, 0xc0, 0xc0, 0xc0, 0xff, 0xff, 0xff, 0xc0, 0xc0, 0xc0, 0x80, 0x80, 0x00, 0x80, 0x80,
0x00, 0xc0, 0xc0, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0xc0, 0xc0, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xc0, 0xc0, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0xc0,
0xc0, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xc0, 0xc0, 0x80, 0x80,
0x00, 0x80, 0x80, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0x80, 0x80, 0x00, 0x80, 0x80, 0x00, 0xc0, 0xc0, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x80,
0x80, 0x80, 0x80, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xc0, 0xc0, 0x80, 0x80,
0x80, 0x80, 0x80, 0x00, 0x80, 0x80, 0x00, 0x80, 0x80, 0x00, 0x80, 0x80, 0x80, 0xc0, 0xc0, 0xc0,
0xc0, 0xc0, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xc0,
0xc0, 0x80, 0x80, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
0x00, 0x80, 0x80, 0x00, 0xc0, 0xc0, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x80,
0x80, 0xc0, 0xc0, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,
0xc0, 0xc0, 0x80, 0x80, 0x80, 0xc0, 0xc0, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x80,
0x00, 0x80, 0x80, 0x00, 0xc0, 0xc0, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xc0, 0xc0,
0x80, 0x80, 0x00, 0xc0, 0xc0, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x80, 0x80, 0x80, 0x80,
0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x80, 0x80, 0xc0,
0xc0, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xc0, 0xc0, 0x80, 0x80,
0x00, 0x80, 0x80, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xc0, 0xc0, 0xc0, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0xc0, 0xc0, 0xc0, 0xc0,
0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0x80, 0x80, 0x80, 0xc0, 0xc0, 0xc0, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x80, 0x80, 0x80, 0x80,
0x00, 0xc0, 0xc0, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xc0, 0xc0, 0x80, 0x80, 0x00, 0x80, 0x80,
0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0xc0, 0xc0,
0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xc0, 0xc0, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xc0, 0xc0, 0x80, 0x80, 0x00, 0x80, 0x80, 0x00, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xc0, 0xc0, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0xc0, 0xc0, 0xc0, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xc0, 0xc0, 0xc0, 0x80, 0x80, 0x00, 0x80, 0x80, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xc0, 0xc0, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0xc0, 0xc0, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xc0, 0xc0, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80,
0x80, 0x80, 0x80, 0x80, 0x00, 0xc0, 0xc0, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xc0, 0xc0, 0x80,
0x80, 0x00, 0x80, 0x80, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0xc0,
0xc0, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

uint8 compressed_16x1x32[] =
{
0x10, 0x01, 0x01, 0x01, 0x01
};

uint8 decompressed_16x1x32[] =
{
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

uint8 compressed_32x32x32[] =
{
0x10, 0x02, 0x02, 0x0a, 0xbb, 0x22, 0x8e, 0xf6, 0xb9, 0x91, 0x91, 0xa9, 0xf5, 0xaa, 0x3c, 0x00,
0x08, 0xf9, 0x5e, 0xd1, 0x59, 0x8f, 0xf7, 0xb8, 0x90, 0x90, 0xa8, 0xf4, 0xab, 0x59, 0xa3, 0x8c,
0x00, 0x06, 0x67, 0x02, 0xe7, 0x6d, 0xd0, 0x36, 0x00, 0x67, 0x1c, 0xa2, 0x8d, 0xb9, 0x20, 0x00,
0x05, 0x5c, 0x2c, 0x9b, 0xe6, 0x0e, 0x00, 0x46, 0xb8, 0x77, 0x66, 0x00, 0x04, 0x4f, 0x3c, 0x8b,
0x98, 0x00, 0x45, 0x56, 0x8b, 0x84, 0x00, 0x03, 0x4d, 0x20, 0x9b, 0x5e, 0x00, 0x04, 0x44, 0x24,
0xa5, 0x62, 0x00, 0x03, 0x3f, 0xd1, 0x5e, 0x00, 0x04, 0x43, 0x20, 0xb5, 0x1c, 0x00, 0x5f, 0x00,
0x00, 0xdc, 0xb0, 0x00, 0x06, 0x33, 0x52, 0xcf, 0x00, 0x4f, 0x00, 0x30, 0xfd, 0x00, 0x08, 0x50,
0xb2, 0x86, 0x00, 0x00, 0x00, 0x4f, 0x00, 0xb4, 0x20, 0x00, 0x09, 0x40, 0xd4, 0x00, 0x00, 0x00,
0x3f, 0x04, 0xae, 0x00, 0x0a, 0x40, 0x8a, 0x32, 0x00, 0x00, 0x3f, 0x3e, 0x5e, 0x00, 0x0a, 0x40,
0x1a, 0x74, 0x00, 0x00, 0x3f, 0x54, 0x0e, 0x00, 0x0b, 0x30, 0x64, 0x00, 0x00, 0x2f, 0x44, 0x00,
0x0c, 0x30, 0x44, 0x00, 0x00, 0x2f, 0x1c, 0x00, 0x0c, 0x30, 0x1e, 0x00, 0x00, 0x2f, 0x03, 0x00,
0x0c, 0x30, 0x03, 0x00, 0x00, 0x2f, 0x27, 0x00, 0x0c, 0x30, 0x29, 0x00, 0x00, 0x2f, 0x49, 0x00,
0x0c, 0x30, 0x4d, 0x00, 0x00, 0x3f, 0x53, 0x1d, 0x00, 0x0b, 0x30, 0x69, 0x00, 0x00, 0x3f, 0x2b,
0x79, 0x00, 0x0a, 0x40, 0x35, 0x6b, 0x00, 0x00, 0x3f, 0x00, 0xb9, 0x00, 0x0a, 0x40, 0xa5, 0x19,
0x00, 0x00, 0x4f, 0x00, 0x9d, 0x4f, 0x00, 0x08, 0x50, 0x0b, 0xd5, 0x00, 0x00, 0x00, 0x5f, 0x00,
0x0d, 0xf0, 0x01, 0x00, 0x07, 0x50, 0xe9, 0x4b, 0x00, 0x00, 0x00, 0x5f, 0x00, 0x00, 0x9d, 0xf6,
0x00, 0x06, 0x33, 0xa1, 0xfa, 0x00, 0x03, 0x3f, 0xf1, 0xbf, 0x00, 0x04, 0x43, 0x67, 0xc6, 0x01,
0x00, 0x04, 0x3d, 0xca, 0xc1, 0x00, 0x04, 0x44, 0x6f, 0x9c, 0x21, 0x00, 0x04, 0x4f, 0x07, 0xc4,
0xf4, 0x00, 0x45, 0xbd, 0x8e, 0x31, 0x00, 0x06, 0x4b, 0xf1, 0xaa, 0x5b, 0x00, 0x56, 0x33, 0xd8,
0xc0, 0x1b, 0x00, 0x07, 0x65, 0xa7, 0x6c, 0xae, 0x9d, 0x29, 0x00, 0x68, 0x15, 0x79, 0xde, 0x60,
0xd5, 0x00, 0x08, 0xf9, 0x0d, 0xab, 0xa0, 0x54, 0x7a, 0xc2, 0xec, 0xf0, 0xd0, 0x8e, 0x56, 0x7c,
0xdb, 0x29, 0x00, 0x02, 0x02, 0x19, 0x3a, 0xb9, 0x36, 0x2a, 0x1e, 0x14, 0x10, 0x10, 0x14, 0x1c,
0x26, 0x34, 0x3a, 0x20, 0x00, 0x00, 0x08, 0xf9, 0x09, 0x21, 0x2f, 0x16, 0x98, 0xf6, 0xd1, 0xcd,
0xf9, 0xb4, 0x38, 0x2f, 0x27, 0x0f, 0x00, 0x07, 0xf0, 0x1f, 0x2d, 0x8c, 0xb1, 0xaf, 0xd2, 0x6a,
0x26, 0x20, 0x54, 0xb2, 0xcd, 0x9b, 0xc2, 0x21, 0x37, 0x25, 0x03, 0x00, 0x05, 0xf0, 0x05, 0x27,
0x3e, 0xcb, 0xae, 0x33, 0x85, 0x6f, 0x4b, 0x33, 0x31, 0x45, 0x65, 0x85, 0x53, 0x66, 0x70, 0xbd,
0x6a, 0x2b, 0x0b, 0x00, 0x04, 0xf0, 0x05, 0x29, 0x56, 0xba, 0x4b, 0x75, 0x39, 0x13, 0x17, 0x23,
0x21, 0x21, 0x23, 0x1b, 0x11, 0x85, 0x21, 0x6d, 0x75, 0x8c, 0x98, 0x29, 0x0f, 0x00, 0x03, 0xf0,
0x03, 0x29, 0x62, 0x6e, 0x79, 0x31, 0x11, 0x11, 0x1b, 0x21, 0x1b, 0x25, 0x29, 0x1b, 0x21, 0xa4,
0x1d, 0x1d, 0x0b, 0x17, 0x79, 0x20, 0x98, 0x25, 0x0b, 0x00, 0x03, 0xf0, 0x21, 0x2a, 0x30, 0x8b,
0x19, 0x1b, 0x21, 0x1f, 0x19, 0x1f, 0x39, 0x49, 0x47, 0x49, 0x2d, 0xb3, 0x19, 0x1f, 0x21, 0x1f,
0x11, 0x7b, 0x1d, 0x60, 0x23, 0x03, 0x00, 0xf0, 0x00, 0x00, 0x19, 0x11, 0x2c, 0x87, 0x1d, 0x25,
0x2b, 0x29, 0x2b, 0x31, 0x2d, 0x25, 0xa2, 0xe3, 0xdc, 0x8c, 0x2f, 0x3f, 0x2b, 0x29, 0x29, 0x25,
0x13, 0x71, 0x19, 0x1c, 0x21, 0x00, 0xf0, 0x00, 0x05, 0x1b, 0x42, 0x5d, 0x11, 0x15, 0x29, 0x2b,
0x2b, 0x27, 0x27, 0x2f, 0x4e, 0x46, 0xf0, 0x0e, 0x5c, 0xc8, 0x21, 0x31, 0x29, 0x2d, 0x29, 0x1b,
0x09, 0x47, 0x1c, 0x11, 0x0f, 0x00, 0x20, 0x00, 0x00, 0xf0, 0x00, 0x13, 0x00, 0x2b, 0x00, 0x00,
0x0f, 0x17, 0x1d, 0x1f, 0x25, 0x23, 0x21, 0x08, 0x12, 0xf0, 0x12, 0x12, 0x50, 0xf2, 0x13, 0x25,
0x1d, 0x17, 0x0f, 0x00, 0x00, 0x3f, 0x16, 0x17, 0x00, 0x20, 0x00, 0x00, 0xf3, 0x00, 0x13, 0x0e,
0x15, 0x00, 0x00, 0x03, 0x0f, 0x15, 0x1b, 0x1d, 0x1f, 0x1b, 0x1f, 0x16, 0xe0, 0x60, 0xe7, 0x05,
0x17, 0x0f, 0x03, 0x00, 0x00, 0x00, 0x03, 0x0f, 0x05, 0x00, 0x00, 0x43, 0x07, 0x09, 0x0b, 0x00,
0xf0, 0x03, 0x0d, 0x11, 0x13, 0x15, 0x11, 0xaf, 0x9b, 0x1a, 0x1a, 0x1a, 0x18, 0x70, 0xbd, 0x0e,
0x23, 0x03, 0x00, 0x50, 0x11, 0x00, 0x0b, 0x00, 0x00, 0x45, 0x09, 0x00, 0x03, 0x00, 0x83, 0x01,
0x05, 0x09, 0x0f, 0x0b, 0xf2, 0xab, 0x18, 0x45, 0x7a, 0xa3, 0x1c, 0x00, 0x30, 0x0b, 0x00, 0x00,
0x24, 0x05, 0x00, 0xb3, 0x84, 0x63, 0x05, 0x07, 0x09, 0x09, 0x07, 0x09, 0x0b, 0xdc, 0x18, 0x54,
0x1a, 0x86, 0x91, 0x1e, 0x00, 0x30, 0x07, 0x00, 0x00, 0x24, 0x03, 0x00, 0x58, 0xbd, 0x60, 0x02,
0x04, 0x06, 0x73, 0x04, 0x00, 0x00, 0x72, 0x93, 0x18, 0x00, 0x30, 0x03, 0x00, 0x00, 0x8f, 0x00,
0x30, 0xe4, 0xac, 0x66, 0x20, 0x06, 0x00, 0x90, 0x05, 0x1e, 0x64, 0xae, 0xf2, 0x7c, 0x02, 0x00,
0x00, 0x9d, 0x06, 0x60, 0x6c, 0x56, 0x7e, 0x98, 0xdf, 0x4b, 0x00, 0xa0, 0x5d, 0xe3, 0x84, 0x7e,
0x54, 0x5a, 0x7c, 0x04, 0x00, 0x00, 0xf0, 0x08, 0x0a, 0x16, 0x12, 0x0a, 0x16, 0x3b, 0xe2, 0x86,
0x76, 0x6c, 0x62, 0x5a, 0x54, 0x50, 0x24, 0xb1, 0x00, 0xb0, 0x53, 0xf9, 0x10, 0x14, 0x0c, 0x10,
0x14, 0x0a, 0x08, 0x00, 0x00, 0xf0, 0x08, 0x0d, 0x18, 0x16, 0x16, 0x14, 0x12, 0x14, 0x0c, 0x10,
0x0c, 0x0e, 0x0a, 0x0c, 0xfb, 0x23, 0xb2, 0x00, 0xc0, 0x53, 0xf8, 0x02, 0x14, 0x14, 0x16, 0x18,
0x1e, 0x07, 0x0c, 0x00, 0x00, 0xf0, 0x06, 0x59, 0x00, 0x20, 0x12, 0x14, 0x18, 0x14, 0x14, 0x0e,
0x0e, 0x0c, 0x10, 0xb0, 0xac, 0x13, 0x00, 0xd0, 0x53, 0xfa, 0x00, 0x14, 0x16, 0x16, 0x12, 0x1c,
0x1c, 0x75, 0x0e, 0x00, 0x00, 0xf3, 0x00, 0x0d, 0x55, 0x34, 0x18, 0x18, 0x16, 0x16, 0x14, 0x12,
0x12, 0x10, 0x12, 0x26, 0x00, 0xe0, 0x53, 0xfd, 0x02, 0x16, 0x18, 0x16, 0x16, 0x18, 0x2c, 0x23,
0x67, 0x02, 0x00, 0x00, 0xf0, 0x00, 0x12, 0xc7, 0x22, 0x26, 0x18, 0x1a, 0x16, 0x16, 0x18, 0x16,
0x16, 0x14, 0x03, 0x00, 0xf0, 0x00, 0x00, 0x4f, 0xf5, 0x00, 0x16, 0x16, 0x16, 0x1a, 0x18, 0x24,
0x3c, 0xa9, 0x14, 0x00, 0x20, 0x00, 0x00, 0xf0, 0x00, 0x02, 0x39, 0x99, 0x4a, 0x28, 0x1e, 0x22,
0x24, 0x20, 0x1c, 0x1c, 0x1a, 0x63, 0x33, 0xf0, 0x00, 0x57, 0xe7, 0x08, 0x1c, 0x1e, 0x24, 0x24,
0x1e, 0x28, 0x48, 0x4d, 0xb1, 0x08, 0x00, 0x20, 0x00, 0x00, 0xf0, 0x00, 0x00, 0x12, 0xe9, 0x59,
0x58, 0x30, 0x2a, 0x2a, 0x2c, 0x2c, 0x28, 0x26, 0x06, 0xf9, 0xe3, 0xf6, 0xd3, 0x12, 0x28, 0x2c,
0x2e, 0x2a, 0x28, 0x30, 0x52, 0x07, 0xc8, 0x1e, 0x00, 0x03, 0xf0, 0x1c, 0xd8, 0x43, 0x58, 0x2a,
0x20, 0x24, 0x26, 0x26, 0x28, 0x26, 0x24, 0x00, 0x26, 0x28, 0xa4, 0x26, 0x28, 0x22, 0x20, 0x2a,
0x4e, 0x08, 0xb8, 0x0c, 0x00, 0x04, 0xf0, 0x1c, 0xb8, 0x5b, 0x5a, 0x36, 0x24, 0x26, 0x28, 0x26,
0x28, 0x2a, 0x2a, 0x28, 0x26, 0x28, 0x94, 0x24, 0x26, 0x34, 0x58, 0x0f, 0xa0, 0x17, 0x04, 0x00,
0x05, 0xf0, 0x1e, 0xc8, 0x91, 0x5a, 0x58, 0x3a, 0x2a, 0x2a, 0x28, 0x24, 0x24, 0x28, 0x2a, 0x2c,
0x36, 0x75, 0x54, 0x6c, 0x5b, 0x8e, 0x13, 0x06, 0x00, 0x06, 0xf0, 0x1c, 0xff, 0xa8, 0x49, 0x48,
0x6c, 0x5e, 0x4e, 0x4a, 0x4a, 0x4e, 0x5a, 0x6a, 0x5a, 0x1d, 0x56, 0xd2, 0xc6, 0x14, 0x04, 0x00,
0x07, 0xf0, 0x14, 0x3b, 0xc8, 0x80, 0xfb, 0x67, 0x17, 0x0e, 0x12, 0x0d, 0x53, 0xd7, 0x90, 0x9a,
0x77, 0x28, 0x18, 0x00, 0x08, 0xf9, 0x02, 0x14, 0x07, 0x95, 0xe6, 0xa6, 0x86, 0x80, 0x9a, 0xd4,
0xbd, 0x25, 0x1a, 0x04, 0x00, 0x02, 0x02, 0x19, 0xbe, 0xb9, 0xb6, 0x98, 0x76, 0x6a, 0x62, 0x62,
0x68, 0x74, 0x8e, 0xb0, 0xbe, 0x20, 0x00, 0x00, 0x08, 0xf9, 0x19, 0x51, 0x45, 0x48, 0xd0, 0xe5,
0xb5, 0xaf, 0xd7, 0xe6, 0x6c, 0x29, 0x5b, 0x23, 0x00, 0x07, 0xf0, 0x4b, 0x23, 0xd6, 0x9d, 0xe1,
0xb8, 0x7a, 0x52, 0x4c, 0x6e, 0xa4, 0xfb, 0x9d, 0xf3, 0x12, 0x37, 0x55, 0x07, 0x00, 0x05, 0xf0,
0x07, 0x5f, 0x92, 0xa3, 0xbc, 0x2c, 0x07, 0x0f, 0x11, 0x13, 0x13, 0x11, 0x0f, 0x09, 0x12, 0x66,
0x90, 0xb5, 0xc8, 0x65, 0x15, 0x00, 0x04, 0xa3, 0x0b, 0x65, 0xca, 0xea, 0x07, 0x2b, 0x1d, 0x0f,
0x05, 0x01, 0xa5, 0x05, 0x0d, 0x1b, 0x29, 0x27, 0xba, 0xe7, 0x4b, 0x1f, 0x00, 0x03, 0xf0, 0x03,
0x5f, 0xe6, 0x96, 0x5b, 0x27, 0x11, 0x15, 0x15, 0x11, 0x13, 0x11, 0x17, 0x13, 0x11, 0xa4, 0x15,
0x13, 0x13, 0x1d, 0x5d, 0x42, 0xe7, 0x43, 0x11, 0x00, 0x03, 0xf0, 0x53, 0xa6, 0x56, 0x75, 0x19,
0x17, 0x1f, 0x1d, 0x1d, 0x1f, 0x49, 0x79, 0x89, 0x71, 0x41, 0xb3, 0x1d, 0x1d, 0x1f, 0x1b, 0x11,
0x65, 0x00, 0xe2, 0x5d, 0x03, 0x00, 0xf0, 0x00, 0x00, 0x35, 0x44, 0x5c, 0x77, 0x1d, 0x23, 0x29,
0x27, 0x27, 0x27, 0x31, 0x5b, 0x0c, 0xe3, 0x32, 0x03, 0x67, 0x4f, 0x27, 0x27, 0x29, 0x25, 0x15,
0x65, 0x0a, 0x9a, 0x4f, 0x00, 0xf0, 0x00, 0x0b, 0x39, 0x72, 0x5f, 0x1b, 0x15, 0x27, 0x27, 0x29,
0x29, 0x29, 0x45, 0x12, 0x1e, 0xf0, 0x0e, 0x26, 0x42, 0x4f, 0x4b, 0x27, 0x27, 0x29, 0x19, 0x0f,
0x67, 0x3e, 0x06, 0x1f, 0x00, 0x20, 0x00, 0x00, 0xf0, 0x00, 0x23, 0x4a, 0x2b, 0x35, 0x13, 0x15,
0x1d, 0x23, 0x23, 0x29, 0x27, 0x21, 0x00, 0x12, 0xf0, 0x12, 0x12, 0x2a, 0x64, 0x45, 0x3f, 0x23,
0x1b, 0x15, 0x19, 0x1d, 0x4d, 0x54, 0x33, 0x00, 0x20, 0x00, 0x00, 0xf0, 0x01, 0x33, 0x1e, 0x4b,
0x17, 0x1f, 0x1d, 0x13, 0x1b, 0x1d, 0x21, 0x21, 0x1b, 0x11, 0x16, 0xf0, 0x16, 0x16, 0x18, 0x3a,
0x8e, 0x31, 0x2f, 0x13, 0x19, 0x1f, 0x17, 0x47, 0x01, 0x1b, 0x07, 0x20, 0x00, 0x00, 0xf0, 0x09,
0x09, 0x07, 0x29, 0x17, 0x1b, 0x21, 0x21, 0x17, 0x17, 0x15, 0x19, 0x02, 0x4f, 0x4d, 0xf0, 0x1a,
0x1a, 0x18, 0x18, 0x4a, 0xb2, 0x25, 0x31, 0x25, 0x1b, 0x19, 0x19, 0x1d, 0x18, 0x1f, 0x20, 0x00,
0x00, 0xf0, 0x13, 0x12, 0x13, 0x07, 0x0d, 0x17, 0x25, 0x3b, 0x45, 0x49, 0x45, 0x43, 0x45, 0x21,
0x9f, 0x23, 0x5d, 0x18, 0xc0, 0x54, 0xd4, 0x1f, 0x23, 0x17, 0x0f, 0x03, 0x1b, 0x16, 0x15, 0x00,
0x00, 0xf0, 0x1b, 0x16, 0x15, 0x00, 0x01, 0x13, 0x44, 0xe3, 0xa7, 0xaf, 0xb9, 0xbf, 0xc3, 0xc5,
0xc7, 0x23, 0x8e, 0x18, 0xc0, 0x1a, 0x62, 0xfd, 0x0b, 0x11, 0x00, 0x00, 0x13, 0x0a, 0x17, 0x00,
0x00, 0xb8, 0x05, 0x04, 0x02, 0x04, 0x0b, 0x13, 0xf8, 0x46, 0x02, 0x04, 0x06, 0xd0, 0x04, 0x00,
0x00, 0x54, 0xe7, 0x03, 0x0d, 0x04, 0x0c, 0x01, 0x03, 0x00, 0x00, 0x8f, 0x06, 0x4c, 0xde, 0xbc,
0x8c, 0x48, 0x08, 0x00, 0x90, 0x04, 0x42, 0x8a, 0xbc, 0xee, 0x88, 0x04, 0x00, 0x00, 0x9d, 0x0e,
0x4e, 0x50, 0x3e, 0x5e, 0x88, 0x89, 0x2f, 0x00, 0xa0, 0x3b, 0x89, 0x7e, 0x60, 0x3e, 0x40, 0x62,
0x18, 0x00, 0x00, 0xf0, 0x1a, 0x0c, 0x0c, 0x08, 0x02, 0x12, 0x1b, 0xa7, 0xdf, 0xe5, 0xeb, 0xef,
0xf1, 0xf5, 0xf7, 0x24, 0x65, 0x00, 0xb0, 0x31, 0x91, 0x16, 0x10, 0x04, 0x06, 0x08, 0x08, 0x1e,
0x00, 0x00, 0x93, 0x0e, 0x09, 0x10, 0x0c, 0x0c, 0x0a, 0x08, 0x08, 0x04, 0x53, 0x00, 0x02, 0x94,
0x66, 0x00, 0xc0, 0x31, 0x9f, 0x01, 0x0a, 0x0a, 0x0c, 0x0e, 0x16, 0x07, 0x0a, 0x00, 0x00, 0xf0,
0x06, 0x45, 0x03, 0x16, 0x08, 0x08, 0x0a, 0x08, 0x06, 0x02, 0x02, 0x02, 0x06, 0x66, 0x64, 0x13,
0x00, 0x43, 0x33, 0xa3, 0x03, 0x08, 0x60, 0x12, 0x12, 0x59, 0x14, 0x00, 0x00, 0xf3, 0x00, 0x21,
0x41, 0x28, 0x0c, 0x0c, 0x0c, 0x0a, 0x08, 0x08, 0x06, 0x04, 0x02, 0x12, 0x00, 0xe0, 0x33, 0x9d,
0x01, 0x08, 0x0c, 0x0c, 0x0c, 0x0e, 0x20, 0x19, 0x55, 0x02, 0x00, 0x00, 0xf0, 0x00, 0x0a, 0x9b,
0x1c, 0x1e, 0x10, 0x0e, 0x0a, 0x0a, 0x0a, 0x08, 0x08, 0x0a, 0x05, 0x00, 0xf0, 0x00, 0x00, 0x31,
0x9b, 0x05, 0x0a, 0x0a, 0x0a, 0x10, 0x0e, 0x1a, 0x2e, 0x7f, 0x09, 0x00, 0x20, 0x00, 0x00, 0xf0,
0x00, 0x04, 0x39, 0x71, 0x36, 0x18, 0x12, 0x14, 0x14, 0x10, 0x10, 0x0e, 0x0a, 0x41, 0x21, 0xf0,
0x00, 0x37, 0x97, 0x00, 0x10, 0x0e, 0x14, 0x14, 0x10, 0x18, 0x34, 0x37, 0x89, 0x0a, 0x00, 0x20,
0x00, 0x00, 0xf0, 0x00, 0x00, 0x0a, 0xb7, 0x3b, 0x42, 0x1c, 0x16, 0x16, 0x16, 0x14, 0x12, 0x10,
0x03, 0xa7, 0xe3, 0xb1, 0x8f, 0x04, 0x12, 0x14, 0x18, 0x16, 0x16, 0x1c, 0x3c, 0x01, 0xe3, 0x04,
0x00, 0x03, 0xf0, 0x0a, 0xdd, 0x29, 0x42, 0x1c, 0x12, 0x14, 0x14, 0x14, 0x16, 0x14, 0x12, 0x05,
0x14, 0x16, 0xa4, 0x14, 0x16, 0x12, 0x12, 0x1c, 0x3a, 0x0e, 0xef, 0x09, 0x00, 0x04, 0xf0, 0x06,
0xf5, 0x35, 0x44, 0x28, 0x18, 0x18, 0x18, 0x16, 0x16, 0x1a, 0x1a, 0x16, 0x16, 0x18, 0x85, 0x16,
0x1a, 0x24, 0x40, 0x01, 0xfd, 0x25, 0x00, 0x05, 0xf0, 0x0c, 0xed, 0x5d, 0x44, 0x42, 0x2a, 0x20,
0x1c, 0x1c, 0x16, 0x16, 0x1c, 0x1c, 0x20, 0x26, 0x75, 0x3e, 0x52, 0x37, 0xf4, 0x1d, 0x08, 0x00,
0x06, 0xf0, 0x10, 0xcb, 0xef, 0x2b, 0x38, 0x4e, 0x46, 0x38, 0x36, 0x36, 0x38, 0x44, 0x4c, 0x44,
0x0d, 0x56, 0xcf, 0xed, 0x02, 0x02, 0x00, 0x07, 0xf0, 0x14, 0x37, 0xed, 0xf8, 0xa9, 0x41, 0x0b,
0x0e, 0x10, 0x03, 0x33, 0x8f, 0xf9, 0xfc, 0x65, 0x28, 0x12, 0x00, 0x08, 0xf9, 0x04, 0x14, 0x11,
0x77, 0xd5, 0xff, 0xf2, 0xf2, 0xfa, 0xe3, 0x95, 0x27, 0x10, 0x08, 0x00, 0x02, 0x02, 0x19, 0xf4,
0xb9, 0xf2, 0xec, 0xe0, 0xf0, 0xfc, 0xfc, 0xf6, 0xe8, 0xea, 0xf2, 0xf4, 0x20, 0x00, 0x00, 0x08,
0xf9, 0x01, 0x07, 0x3c, 0xd0, 0xfe, 0xfe, 0xfa, 0xfa, 0xfc, 0xfe, 0xde, 0x74, 0x03, 0x03, 0x00,
0x07, 0xf0, 0x09, 0x7e, 0xf6, 0xd0, 0x42, 0x20, 0x10, 0x08, 0x08, 0x0c, 0x18, 0x36, 0x98, 0xfe,
0xbe, 0x37, 0x09, 0x01, 0x00, 0x05, 0xf0, 0x01, 0x05, 0xe6, 0x8e, 0x1c, 0x00, 0x00, 0x00, 0x01,
0x03, 0x03, 0x01, 0x00, 0x00, 0x00, 0x66, 0x10, 0x50, 0xf4, 0x06, 0x01, 0x00, 0x04, 0x54, 0x01,
0x03, 0xf0, 0x2e, 0x00, 0x54, 0x02, 0x04, 0x04, 0x02, 0x00, 0x55, 0x20, 0xf8, 0x36, 0x05, 0x00,
0x03, 0x66, 0x02, 0x03, 0xf4, 0x20, 0x01, 0x00, 0x25, 0x05, 0x00, 0x64, 0x03, 0x0e, 0xca, 0x3c,
0x02, 0x00, 0x03, 0xf0, 0x0b, 0xdc, 0x18, 0x11, 0x07, 0x03, 0x01, 0x00, 0x00, 0x00, 0x33, 0x6b,
0x81, 0x5f, 0x27, 0xa4, 0x00, 0x00, 0x00, 0x03, 0x07, 0x15, 0x02, 0xba, 0x01, 0x00, 0xf0, 0x00,
0x00, 0x05, 0xb8, 0x26, 0x1d, 0x0f, 0x09, 0x0b, 0x07, 0x07, 0x05, 0x0f, 0x51, 0x19, 0xe3, 0x02,
0x25, 0x5d, 0x37, 0x07, 0x09, 0x07, 0x07, 0x09, 0x19, 0x0a, 0xcc, 0x05, 0x00, 0xf0, 0x00, 0x01,
0x22, 0x3c, 0x21, 0x11, 0x01, 0x0b, 0x09, 0x0d, 0x0b, 0x0b, 0x35, 0x02, 0x0e, 0xf0, 0x0e, 0x0e,
0x0a, 0x51, 0x3b, 0x0d, 0x0d, 0x0b, 0x03, 0x09, 0x41, 0x26, 0x74, 0x03, 0x00, 0x20, 0x00, 0x00,
0xf0, 0x00, 0x06, 0x8c, 0x0d, 0x43, 0x15, 0x07, 0x05, 0x07, 0x07, 0x0b, 0x09, 0x0b, 0x0a, 0x12,
0xf0, 0x12, 0x12, 0x16, 0x1c, 0x49, 0x31, 0x07, 0x05, 0x07, 0x1b, 0x23, 0x27, 0x4e, 0x02, 0x00,
0x20, 0x00, 0x00, 0xf0, 0x00, 0x02, 0x10, 0x59, 0x1f, 0x1f, 0x19, 0x05, 0x07, 0x05, 0x05, 0x07,
0x02, 0x04, 0x16, 0xf0, 0x16, 0x16, 0x18, 0x20, 0x32, 0x43, 0x2f, 0x05, 0x15, 0x1f, 0x15, 0x71,
0x02, 0x22, 0x02, 0x20, 0x00, 0x00, 0xf0, 0x02, 0x30, 0x07, 0x43, 0x1d, 0x1d, 0x29, 0x1f, 0x0d,
0x09, 0x07, 0x07, 0x26, 0x10, 0x09, 0xf0, 0x1a, 0x1a, 0x18, 0x18, 0x28, 0x46, 0x3d, 0x41, 0x31,
0x1d, 0x23, 0x21, 0x21, 0x5e, 0x05, 0x20, 0x00, 0x00, 0xf0, 0x00, 0x30, 0x2b, 0x0b, 0x13, 0x23,
0x3b, 0x67, 0x77, 0x77, 0x6d, 0x67, 0x65, 0x29, 0x33, 0x23, 0x15, 0x18, 0xc0, 0x2e, 0x54, 0x49,
0x35, 0x23, 0x1b, 0x00, 0x3d, 0x10, 0x08, 0x00, 0x00, 0xf0, 0x0b, 0x10, 0x31, 0x01, 0x07, 0x2b,
0x01, 0x8c, 0xae, 0xa4, 0x96, 0x8e, 0x8a, 0x8a, 0x88, 0x23, 0x46, 0x18, 0xc0, 0x1a, 0x3c, 0x88,
0x31, 0x25, 0x00, 0x00, 0x27, 0x09, 0x09, 0x00, 0x00, 0xb8, 0x06, 0x11, 0x00, 0x02, 0x05, 0x21,
0x94, 0x28, 0x02, 0x04, 0x06, 0xd0, 0x04, 0x00, 0x00, 0x30, 0xa6, 0x21, 0x09, 0x03, 0x10, 0x15,
0x0a, 0x00, 0x00, 0x8f, 0x06, 0x48, 0x8c, 0x94, 0x82, 0x5a, 0x0a, 0x00, 0x90, 0x0e, 0x56, 0x7e,
0x94, 0x9a, 0x56, 0x0a, 0x00, 0x00, 0x9d, 0x06, 0x18, 0x1c, 0x16, 0x1e, 0x56, 0x33, 0x11, 0x00,
0xa0, 0x15, 0x31, 0x5a, 0x24, 0x16, 0x16, 0x20, 0x08, 0x00, 0x00, 0xf0, 0x04, 0x04, 0x02, 0x00,
0x01, 0x10, 0x08, 0x2b, 0x39, 0x39, 0x39, 0x37, 0x33, 0x33, 0x35, 0x24, 0x15, 0x00, 0xb0, 0x0b,
0x25, 0x1e, 0x0a, 0x01, 0x01, 0x00, 0x02, 0x08, 0x00, 0x00, 0xf0, 0x07, 0x0f, 0x04, 0x04, 0x02,
0x00, 0x03, 0x00, 0x05, 0x00, 0x01, 0x01, 0x07, 0x05, 0x1e, 0x23, 0x16, 0x00, 0xc0, 0x0b, 0x2f,
0x01, 0x01, 0x00, 0x02, 0x04, 0x06, 0x05, 0x0f, 0x00, 0x00, 0xf0, 0x03, 0x3b, 0x01, 0x08, 0x00,
0x00, 0x02, 0x00, 0x01, 0x07, 0x05, 0x05, 0x01, 0x14, 0x18, 0x13, 0x00, 0xd0, 0x0d, 0x31, 0x05,
0x01, 0x00, 0x00, 0x00, 0x08, 0x08, 0x2f, 0x07, 0x00, 0x00, 0xf3, 0x00, 0x57, 0x15, 0x10, 0x04,
0x04, 0x02, 0x01, 0x00, 0x01, 0x01, 0x03, 0x05, 0x04, 0x00, 0xe0, 0x0f, 0x31, 0x03, 0x00, 0x02,
0x02, 0x04, 0x06, 0x0c, 0x09, 0x4d, 0x05, 0x00, 0x00, 0xf0, 0x00, 0x21, 0x51, 0x0a, 0x0c, 0x02,
0x02, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x05, 0x00, 0xf0, 0x00, 0x00, 0x0f, 0x2f, 0x05, 0x01,
0x01, 0x01, 0x02, 0x00, 0x08, 0x12, 0x31, 0x57, 0x00, 0x20, 0x00, 0x00, 0xf0, 0x00, 0x01, 0x73,
0x25, 0x16, 0x0a, 0x04, 0x02, 0x04, 0x00, 0x00, 0x01, 0x00, 0x17, 0x09, 0xf0, 0x00, 0x11, 0x2f,
0x05, 0x00, 0x01, 0x04, 0x04, 0x04, 0x0c, 0x16, 0x13, 0x71, 0x09, 0x00, 0x20, 0x00, 0x00, 0xf0,
0x00, 0x00, 0x21, 0x97, 0x13, 0x1a, 0x0c, 0x08, 0x04, 0x04, 0x02, 0x00, 0x03, 0x07, 0x3d, 0xe3,
0x3f, 0x35, 0x07, 0x00, 0x02, 0x06, 0x04, 0x08, 0x0a, 0x18, 0x00, 0x79, 0x55, 0x00, 0x03, 0xf0,
0x43, 0x81, 0x0d, 0x1a, 0x0c, 0x06, 0x06, 0x04, 0x02, 0x04, 0x04, 0x02, 0x05, 0x04, 0x04, 0xa4,
0x02, 0x08, 0x02, 0x04, 0x0a, 0x18, 0x04, 0x6d, 0x6d, 0x00, 0x04, 0xf0, 0x65, 0x8d, 0x0d, 0x1a,
0x10, 0x0a, 0x0a, 0x0a, 0x06, 0x04, 0x08, 0x08, 0x04, 0x06, 0x0a, 0x94, 0x06, 0x0c, 0x12, 0x1a,
0x02, 0x73, 0x85, 0x07, 0x00, 0x05, 0xf0, 0x5d, 0xaf, 0x1d, 0x1a, 0x1a, 0x12, 0x0c, 0x0c, 0x0c,
0x06, 0x06, 0x0c, 0x0c, 0x0c, 0x10, 0x75, 0x1a, 0x20, 0x0f, 0x91, 0x83, 0x05, 0x00, 0x06, 0xf0,
0x3b, 0xc3, 0x6d, 0x0b, 0x16, 0x20, 0x1c, 0x16, 0x18, 0x18, 0x16, 0x1a, 0x20, 0x1c, 0x00, 0x56,
0x57, 0xbb, 0x65, 0x03, 0x00, 0x07, 0xf0, 0x17, 0x8d, 0xcf, 0x87, 0x43, 0x11, 0x02, 0x08, 0x0a,
0x04, 0x0d, 0x35, 0x79, 0xbf, 0xa7, 0x28, 0x2d, 0x00, 0x08, 0xf9, 0x01, 0x17, 0x73, 0xb5, 0xd5,
0xcf, 0xb5, 0xb3, 0xc7, 0xd3, 0xc1, 0x85, 0x31, 0x03, 0x00
};

uint8 decompressed_32x32x32[] =
{
0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00,
0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00,
0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00, 0x7b, 0x5c, 0x1b, 0x14,
0x80, 0x57, 0x16, 0x3c, 0x89, 0x54, 0x12, 0x60, 0x98, 0x56, 0x10, 0x75, 0x9a, 0x57, 0x0f, 0x77,
0x8e, 0x55, 0x11, 0x67, 0x82, 0x56, 0x15, 0x46, 0x7c, 0x59, 0x19, 0x1f, 0x7a, 0x5f, 0x1d, 0x00,
0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00,
0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00,
0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00,
0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00,
0x7b, 0x5d, 0x1c, 0x07, 0x86, 0x55, 0x13, 0x56, 0xb4, 0x68, 0x21, 0xb0, 0xd6, 0x98, 0x66, 0xea,
0xeb, 0xc2, 0xa3, 0xff, 0xf1, 0xd4, 0xbf, 0xff, 0xf3, 0xdd, 0xcd, 0xff, 0xf4, 0xde, 0xcf, 0xff,
0xf2, 0xd8, 0xc4, 0xff, 0xec, 0xc8, 0xab, 0xff, 0xdd, 0xa4, 0x78, 0xf4, 0xbd, 0x73, 0x30, 0xc2,
0x93, 0x57, 0x10, 0x6e, 0x7c, 0x5b, 0x1b, 0x15, 0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00,
0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00,
0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00,
0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00, 0x86, 0x55, 0x13, 0x54,
0xc2, 0x79, 0x3a, 0xd1, 0xee, 0xcc, 0xaf, 0xff, 0xf8, 0xec, 0xe1, 0xff, 0xf8, 0xed, 0xe4, 0xff,
0xf4, 0xe3, 0xd7, 0xff, 0xf0, 0xda, 0xcb, 0xff, 0xef, 0xd6, 0xc6, 0xff, 0xef, 0xd6, 0xc6, 0xff,
0xf0, 0xda, 0xcb, 0xff, 0xf3, 0xe2, 0xd5, 0xff, 0xf8, 0xec, 0xe4, 0xff, 0xfa, 0xf0, 0xe8, 0xff,
0xf3, 0xd9, 0xc3, 0xff, 0xd0, 0x8e, 0x57, 0xe5, 0x91, 0x56, 0x11, 0x6b, 0x7a, 0x5f, 0x1d, 0x00,
0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00,
0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00,
0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00, 0x98, 0x57, 0x0f, 0x79, 0xe8, 0xbb, 0x93, 0xff,
0xf9, 0xf1, 0xe6, 0xff, 0xf4, 0xe2, 0xd4, 0xff, 0xed, 0xd0, 0xbd, 0xff, 0xe8, 0xc6, 0xae, 0xff,
0xe6, 0xc0, 0xa8, 0xff, 0xe5, 0xbe, 0xa4, 0xff, 0xe3, 0xbb, 0xa1, 0xff, 0xe3, 0xbb, 0xa1, 0xff,
0xe5, 0xbe, 0xa4, 0xff, 0xe6, 0xc0, 0xa8, 0xff, 0xe8, 0xc6, 0xaf, 0xff, 0xec, 0xce, 0xbb, 0xff,
0xf3, 0xe0, 0xd2, 0xff, 0xfc, 0xf6, 0xee, 0xff, 0xef, 0xcd, 0xae, 0xff, 0xad, 0x5e, 0x13, 0xa0,
0x7c, 0x5e, 0x1b, 0x0e, 0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00,
0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00,
0x7a, 0x5f, 0x1d, 0x04, 0xa9, 0x59, 0x0e, 0x9e, 0xf0, 0xce, 0xab, 0xff, 0xf7, 0xea, 0xdc, 0xff,
0xec, 0xcf, 0xb9, 0xff, 0xe7, 0xc1, 0xa8, 0xff, 0xe4, 0xbb, 0xa0, 0xff, 0xe2, 0xb6, 0x99, 0xff,
0xe0, 0xb2, 0x93, 0xff, 0xdf, 0xb0, 0x90, 0xff, 0xe0, 0xb0, 0x8f, 0xff, 0xe0, 0xb0, 0x8f, 0xff,
0xdf, 0xb0, 0x90, 0xff, 0xe0, 0xb2, 0x93, 0xff, 0xe2, 0xb6, 0x99, 0xff, 0xe4, 0xbb, 0xa0, 0xff,
0xe6, 0xc1, 0xa8, 0xff, 0xec, 0xcd, 0xb8, 0xff, 0xf7, 0xe9, 0xdc, 0xff, 0xf6, 0xe4, 0xcc, 0xff,
0xbe, 0x6d, 0x25, 0xc7, 0x7d, 0x5b, 0x1a, 0x19, 0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00,
0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00,
0xad, 0x5c, 0x0f, 0x9f, 0xf0, 0xd4, 0xb2, 0xff, 0xf7, 0xe9, 0xd9, 0xff, 0xea, 0xc8, 0xaf, 0xff,
0xe4, 0xbb, 0x9e, 0xff, 0xe2, 0xb5, 0x96, 0xff, 0xdf, 0xaf, 0x8d, 0xff, 0xdd, 0xaa, 0x85, 0xff,
0xdd, 0xa7, 0x80, 0xff, 0xdd, 0xa5, 0x7c, 0xff, 0xdc, 0xa3, 0x7a, 0xff, 0xdc, 0xa3, 0x7a, 0xff,
0xdd, 0xa5, 0x7c, 0xff, 0xdd, 0xa7, 0x80, 0xff, 0xdd, 0xaa, 0x85, 0xff, 0xe1, 0xb0, 0x8e, 0xff,
0xe0, 0xb4, 0x95, 0xff, 0xe3, 0xbb, 0x9e, 0xff, 0xea, 0xc9, 0xb0, 0xff, 0xf5, 0xe5, 0xd4, 0xff,
0xf8, 0xec, 0xd5, 0xff, 0xc0, 0x6e, 0x26, 0xcb, 0x7e, 0x5f, 0x1b, 0x11, 0x7a, 0x5f, 0x1d, 0x00,
0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00, 0x9c, 0x5a, 0x0f, 0x79,
0xee, 0xcb, 0xa3, 0xff, 0xf7, 0xe9, 0xd4, 0xff, 0xea, 0xc8, 0xad, 0xff, 0xe4, 0xba, 0x9a, 0xff,
0xe1, 0xb2, 0x8e, 0xff, 0xdf, 0xab, 0x84, 0xff, 0xdd, 0xa5, 0x7a, 0xff, 0xdc, 0xa0, 0x72, 0xff,
0xdb, 0x9c, 0x6c, 0xff, 0xdb, 0x9b, 0x69, 0xff, 0xdb, 0x9a, 0x68, 0xff, 0xdf, 0xa6, 0x7a, 0xff,
0xdb, 0x9b, 0x69, 0xff, 0xdb, 0x9c, 0x6c, 0xff, 0xdc, 0xa0, 0x72, 0xff, 0xdd, 0xa5, 0x7a, 0xff,
0xdf, 0xab, 0x84, 0xff, 0xe1, 0xb2, 0x8e, 0xff, 0xe5, 0xbb, 0x9b, 0xff, 0xe9, 0xc8, 0xad, 0xff,
0xf6, 0xe5, 0xd1, 0xff, 0xf7, 0xe6, 0xca, 0xff, 0xb5, 0x64, 0x15, 0xae, 0x7a, 0x5f, 0x1d, 0x01,
0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00, 0x8b, 0x5a, 0x14, 0x4f, 0xe8, 0xb6, 0x84, 0xfe,
0xf8, 0xe9, 0xd0, 0xff, 0xea, 0xc8, 0xa8, 0xff, 0xe4, 0xba, 0x95, 0xff, 0xe0, 0xaf, 0x85, 0xff,
0xdf, 0xa7, 0x79, 0xff, 0xdd, 0xa0, 0x6e, 0xff, 0xdc, 0x9b, 0x64, 0xff, 0xdc, 0x97, 0x5e, 0xff,
0xdd, 0x94, 0x59, 0xff, 0xdf, 0x9d, 0x66, 0xff, 0xfa, 0xee, 0xe5, 0xff, 0xff, 0xff, 0xff, 0xff,
0xf6, 0xe3, 0xd3, 0xff, 0xdf, 0x9a, 0x63, 0xff, 0xdc, 0x97, 0x5e, 0xff, 0xdc, 0x9b, 0x64, 0xff,
0xdc, 0x9f, 0x6d, 0xff, 0xdf, 0xa7, 0x79, 0xff, 0xe1, 0xb0, 0x87, 0xff, 0xe4, 0xba, 0x95, 0xff,
0xea, 0xc7, 0xa8, 0xff, 0xf7, 0xe7, 0xce, 0xff, 0xf2, 0xd6, 0xb1, 0xff, 0xa5, 0x5d, 0x0e, 0x84,
0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x7a, 0x5f, 0x1d, 0x00, 0x7b, 0x5d, 0x1c, 0x07, 0xc5, 0x77, 0x31, 0xd7, 0xfb, 0xef, 0xd1, 0xff,
0xed, 0xce, 0xab, 0xff, 0xe5, 0xbc, 0x94, 0xff, 0xe2, 0xb1, 0x86, 0xff, 0xdf, 0xa5, 0x74, 0xff,
0xdd, 0x9d, 0x67, 0xff, 0xdd, 0x98, 0x5e, 0xff, 0xdc, 0x93, 0x56, 0xff, 0xdd, 0x90, 0x50, 0xff,
0xdd, 0x8f, 0x4c, 0xff, 0xeb, 0xbe, 0x98, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xf7, 0xe6, 0xd7, 0xff, 0xdf, 0x97, 0x5a, 0xff, 0xdc, 0x93, 0x56, 0xff,
0xdd, 0x98, 0x5e, 0xff, 0xdd, 0x9d, 0x67, 0xff, 0xdf, 0xa6, 0x75, 0xff, 0xe2, 0xb2, 0x86, 0xff,
0xe4, 0xbb, 0x94, 0xff, 0xec, 0xcd, 0xaa, 0xff, 0xfc, 0xf2, 0xd8, 0xff, 0xde, 0xa2, 0x67, 0xf9,
0x7f, 0x5a, 0x19, 0x26, 0x7a, 0x5f, 0x1d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x7a, 0x5f, 0x1d, 0x00, 0x8c, 0x58, 0x13, 0x56, 0xee, 0xc5, 0x95, 0xff, 0xf6, 0xe1, 0xc0, 0xff,
0xe7, 0xbf, 0x98, 0xff, 0xe4, 0xb4, 0x88, 0xff, 0xe1, 0xaa, 0x79, 0xff, 0xdf, 0xa0, 0x69, 0xff,
0xde, 0x98, 0x5c, 0xff, 0xdd, 0x93, 0x52, 0xff, 0xdd, 0x8f, 0x4b, 0xff, 0xdd, 0x8c, 0x45, 0xff,
0xdd, 0x8a, 0x42, 0xff, 0xee, 0xc1, 0x9a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0xe5, 0xd5, 0xff, 0xdf, 0x96, 0x56, 0xff,
0xde, 0x93, 0x53, 0xff, 0xde, 0x98, 0x5c, 0xff, 0xe0, 0xa1, 0x6a, 0xff, 0xe1, 0xaa, 0x79, 0xff,
0xe4, 0xb4, 0x88, 0xff, 0xe8, 0xc0, 0x98, 0xff, 0xf3, 0xdb, 0xba, 0xff, 0xf7, 0xe2, 0xbc, 0xff,
0xab, 0x5f, 0x0f, 0x91, 0x7a, 0x5f, 0x1d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x7a, 0x5f, 0x1d, 0x00, 0xb8, 0x69, 0x1a, 0xb3, 0xf9, 0xe6, 0xc0, 0xff, 0xee, 0xcd, 0xa6, 0xff,
0xe5, 0xb9, 0x8c, 0xff, 0xe2, 0xae, 0x7c, 0xff, 0xe0, 0xa4, 0x6e, 0xff, 0xe0, 0x9b, 0x5e, 0xff,
0xde, 0x94, 0x52, 0xff, 0xde, 0x8f, 0x49, 0xff, 0xde, 0x8c, 0x42, 0xff, 0xdf, 0x8a, 0x3d, 0xff,
0xe0, 0x89, 0x39, 0xff, 0xec, 0xb8, 0x87, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xe5, 0xd5, 0xff,
0xe0, 0x94, 0x52, 0xff, 0xde, 0x94, 0x51, 0xff, 0xdf, 0x9b, 0x5e, 0xff, 0xe0, 0xa4, 0x6e, 0xff,
0xe2, 0xae, 0x7d, 0xff, 0xe5, 0xb9, 0x8c, 0xff, 0xed, 0xcb, 0xa4, 0xff, 0xfc, 0xef, 0xce, 0xff,
0xd2, 0x8a, 0x43, 0xe4, 0x7d, 0x5e, 0x1c, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x7c, 0x5c, 0x1a, 0x16, 0xd6, 0x8c, 0x47, 0xf0, 0xfa, 0xe8, 0xc0, 0xff, 0xea, 0xc2, 0x96, 0xff,
0xe5, 0xb5, 0x83, 0xff, 0xe2, 0xaa, 0x72, 0xff, 0xdf, 0x9f, 0x62, 0xff, 0xe0, 0x97, 0x54, 0xff,
0xdf, 0x91, 0x48, 0xff, 0xe2, 0x8e, 0x42, 0xff, 0xe1, 0x8b, 0x3b, 0xff, 0xe2, 0x89, 0x37, 0xff,
0xe1, 0x86, 0x31, 0xff, 0xe2, 0x85, 0x2f, 0xff, 0xf3, 0xcd, 0xa9, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xf9, 0xe6, 0xd5, 0xff, 0xe1, 0x96, 0x51, 0xff, 0xe0, 0x97, 0x54, 0xff, 0xe0, 0xa0, 0x63, 0xff,
0xe2, 0xaa, 0x72, 0xff, 0xe5, 0xb5, 0x83, 0xff, 0xe9, 0xc2, 0x96, 0xff, 0xf8, 0xe6, 0xc0, 0xff,
0xea, 0xb7, 0x7e, 0xff, 0x81, 0x54, 0x15, 0x43, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x80, 0x55, 0x16, 0x40, 0xde, 0x91, 0x4e, 0xff, 0xf8, 0xe0, 0xb4, 0xff, 0xe8, 0xbc, 0x8b, 0xff,
0xe4, 0xaf, 0x78, 0xff, 0xe2, 0xa5, 0x68, 0xff, 0xe1, 0x9b, 0x59, 0xff, 0xe0, 0x93, 0x4a, 0xff,
0xe2, 0x8f, 0x42, 0xff, 0xe2, 0x8c, 0x3a, 0xff, 0xe2, 0x89, 0x35, 0xff, 0xe3, 0x87, 0x30, 0xff,
0xe5, 0x86, 0x2c, 0xff, 0xe5, 0x84, 0x29, 0xff, 0xe4, 0x83, 0x27, 0xff, 0xf4, 0xcc, 0xa6, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xf9, 0xe6, 0xd5, 0xff, 0xe1, 0x98, 0x53, 0xff, 0xe1, 0x9b, 0x59, 0xff,
0xe2, 0xa5, 0x68, 0xff, 0xe4, 0xaf, 0x78, 0xff, 0xe7, 0xbb, 0x8a, 0xff, 0xf5, 0xdb, 0xb1, 0xff,
0xed, 0xbb, 0x82, 0xff, 0x89, 0x4f, 0x0f, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x7e, 0x48, 0x12, 0x65, 0xdc, 0x8b, 0x49, 0xff, 0xf7, 0xda, 0xa9, 0xff, 0xe8, 0xb8, 0x82, 0xff,
0xe5, 0xae, 0x73, 0xff, 0xda, 0x9c, 0x5d, 0xff, 0xdd, 0xa9, 0x77, 0xff, 0xf6, 0xe7, 0xd9, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0xe1, 0xd0, 0xff, 0xd2, 0x90, 0x51, 0xff,
0xdd, 0x9d, 0x5e, 0xff, 0xe5, 0xad, 0x72, 0xff, 0xe8, 0xb8, 0x82, 0xff, 0xf5, 0xd7, 0xa7, 0xff,
0xec, 0xb7, 0x7d, 0xff, 0x85, 0x40, 0x0b, 0x9f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x7b, 0x41, 0x0f, 0x79, 0xd0, 0x64, 0x19, 0xff, 0xe9, 0xb2, 0x73, 0xff, 0xdd, 0x99, 0x57, 0xff,
0xd6, 0x7f, 0x34, 0xff, 0xaf, 0x58, 0x11, 0xff, 0xf7, 0xee, 0xe7, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xeb, 0xd5, 0xc3, 0xff,
0xb0, 0x5e, 0x1c, 0xff, 0xd3, 0x7d, 0x33, 0xff, 0xdd, 0x99, 0x58, 0xff, 0xea, 0xb7, 0x7a, 0xff,
0xdc, 0x86, 0x3f, 0xff, 0x81, 0x34, 0x09, 0xb4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x78, 0x3e, 0x0f, 0x7b, 0xac, 0x3e, 0x01, 0xff, 0xa3, 0x43, 0x01, 0xff, 0x93, 0x3b, 0x01, 0xff,
0x95, 0x39, 0x01, 0xff, 0x82, 0x34, 0x01, 0xff, 0xf2, 0xea, 0xe4, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0xd3, 0xc6, 0xff,
0x85, 0x3d, 0x0d, 0xff, 0x94, 0x38, 0x01, 0xff, 0x93, 0x3b, 0x01, 0xff, 0x9d, 0x40, 0x01, 0xff,
0xb1, 0x42, 0x01, 0xff, 0x7c, 0x32, 0x08, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x75, 0x41, 0x11, 0x6d, 0xb5, 0x3c, 0x01, 0xff, 0xa3, 0x42, 0x01, 0xff, 0x92, 0x39, 0x01, 0xff,
0x98, 0x3f, 0x01, 0xff, 0x93, 0x3e, 0x01, 0xff, 0xa8, 0x6e, 0x43, 0xff, 0xeb, 0xdc, 0xcf, 0xff,
0xfe, 0xfe, 0xfe, 0xff, 0xfd, 0xfd, 0xfd, 0xff, 0xfc, 0xfc, 0xfc, 0xff, 0xfc, 0xfc, 0xfc, 0xff,
0xfc, 0xfc, 0xfc, 0xff, 0xfc, 0xfc, 0xfc, 0xff, 0xfc, 0xfc, 0xfc, 0xff, 0xfc, 0xfc, 0xfc, 0xff,
0xfc, 0xfc, 0xfc, 0xff, 0xfc, 0xfc, 0xfc, 0xff, 0xfc, 0xfc, 0xfc, 0xff, 0xfd, 0xfd, 0xfd, 0xff,
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe7, 0xd5, 0xc6, 0xff, 0x91, 0x47, 0x10, 0xff,
0x96, 0x3f, 0x01, 0xff, 0x99, 0x3f, 0x01, 0xff, 0x95, 0x39, 0x01, 0xff, 0x95, 0x3a, 0x01, 0xff,
0xbc, 0x43, 0x01, 0xff, 0x77, 0x34, 0x0a, 0xa7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x7b, 0x4f, 0x14, 0x4b, 0xad, 0x31, 0x01, 0xff, 0xbc, 0x4d, 0x01, 0xff, 0x93, 0x39, 0x01, 0xff,
0x9c, 0x40, 0x01, 0xff, 0xa9, 0x48, 0x01, 0xff, 0xa9, 0x4c, 0x01, 0xff, 0xa5, 0x4e, 0x01, 0xff,
0xa7, 0x52, 0x01, 0xff, 0xab, 0x55, 0x01, 0xff, 0xb1, 0x59, 0x01, 0xff, 0xb5, 0x5c, 0x01, 0xff,
0xb7, 0x5e, 0x00, 0xff, 0xb7, 0x5f, 0x01, 0xff, 0xb8, 0x60, 0x02, 0xff, 0xd9, 0xb5, 0x8e, 0xff,
0xf0, 0xf0, 0xf0, 0xff, 0xf0, 0xf0, 0xf0, 0xff, 0xf0, 0xf0, 0xf0, 0xff, 0xf1, 0xf1, 0xf1, 0xff,
0xf2, 0xf2, 0xf2, 0xff, 0xe1, 0xce, 0xbc, 0xff, 0xa3, 0x54, 0x0f, 0xff, 0xaa, 0x4d, 0x01, 0xff,
0xa9, 0x48, 0x01, 0xff, 0x99, 0x3f, 0x01, 0xff, 0x95, 0x39, 0x01, 0xff, 0xa9, 0x44, 0x01, 0xff,
0xc1, 0x3e, 0x01, 0xff, 0x7c, 0x40, 0x0e, 0x85, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x7b, 0x59, 0x19, 0x21, 0x95, 0x28, 0x01, 0xf8, 0xd2, 0x57, 0x03, 0xff, 0x99, 0x3d, 0x01, 0xff,
0xa6, 0x47, 0x01, 0xff, 0xbb, 0x54, 0x01, 0xff, 0xc7, 0x5f, 0x01, 0xff, 0xd9, 0x6c, 0x01, 0xff,
0xe3, 0x75, 0x01, 0xff, 0xe7, 0x7a, 0x02, 0xff, 0xe8, 0x7c, 0x04, 0xff, 0xe9, 0x7e, 0x06, 0xff,
0xea, 0x81, 0x08, 0xff, 0xcc, 0x70, 0x07, 0xff, 0xd2, 0xb0, 0x89, 0xff, 0xe4, 0xe4, 0xe4, 0xff,
0xe4, 0xe4, 0xe4, 0xff, 0xe4, 0xe4, 0xe4, 0xff, 0xe4, 0xe4, 0xe4, 0xff, 0xe5, 0xe5, 0xe5, 0xff,
0xdb, 0xc8, 0xb5, 0xff, 0xb7, 0x64, 0x0e, 0xff, 0xc8, 0x64, 0x01, 0xff, 0xc5, 0x5f, 0x01, 0xff,
0xbb, 0x54, 0x01, 0xff, 0xa7, 0x47, 0x01, 0xff, 0x95, 0x3b, 0x01, 0xff, 0xc8, 0x52, 0x01, 0xff,
0xb9, 0x33, 0x01, 0xff, 0x78, 0x4b, 0x14, 0x53, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x7a, 0x5e, 0x1d, 0x02, 0x7d, 0x2d, 0x06, 0xc9, 0xd6, 0x5b, 0x09, 0xff, 0xbb, 0x52, 0x01, 0xff,
0xb5, 0x53, 0x01, 0xff, 0xca, 0x62, 0x01, 0xff, 0xdc, 0x70, 0x01, 0xff, 0xe9, 0x7d, 0x03, 0xff,
0xea, 0x81, 0x08, 0xff, 0xec, 0x86, 0x0b, 0xff, 0xec, 0x87, 0x0e, 0xff, 0xed, 0x8b, 0x11, 0xff,
0xd7, 0x80, 0x11, 0xff, 0xc4, 0x98, 0x5f, 0xff, 0xd7, 0xd7, 0xd7, 0xff, 0xd7, 0xd7, 0xd7, 0xff,
0xd7, 0xd7, 0xd7, 0xff, 0xd8, 0xd8, 0xd7, 0xff, 0xd8, 0xd8, 0xd8, 0xff, 0xd1, 0xc0, 0xad, 0xff,
0xb8, 0x6f, 0x14, 0xff, 0xd6, 0x77, 0x07, 0xff, 0xe9, 0x7d, 0x03, 0xff, 0xde, 0x72, 0x01, 0xff,
0xca, 0x62, 0x01, 0xff, 0xb9, 0x54, 0x01, 0xff, 0xa6, 0x48, 0x01, 0xff, 0xd9, 0x61, 0x0a, 0xff,
0x8a, 0x27, 0x01, 0xf2, 0x7b, 0x5b, 0x1a, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x7a, 0x5f, 0x1d, 0x00, 0x7c, 0x47, 0x10, 0x72, 0xce, 0x4c, 0x02, 0xff, 0xe8, 0x78, 0x0c, 0xff,
0xc5, 0x5f, 0x01, 0xff, 0xda, 0x72, 0x01, 0xff, 0xe9, 0x7f, 0x03, 0xff, 0xec, 0x87, 0x0b, 0xff,
0xee, 0x8f, 0x13, 0xff, 0xef, 0x95, 0x19, 0xff, 0xef, 0x98, 0x1d, 0xff, 0xf1, 0x9c, 0x21, 0xff,
0xd6, 0x8e, 0x1f, 0xff, 0xc2, 0xa1, 0x6f, 0xff, 0xcc, 0xcc, 0xcc, 0xff, 0xcc, 0xcc, 0xcc, 0xff,
0xcc, 0xcc, 0xcc, 0xff, 0xcc, 0xcc, 0xcc, 0xff, 0xc8, 0xbb, 0xa8, 0xff, 0xb8, 0x79, 0x21, 0xff,
0xda, 0x88, 0x17, 0xff, 0xee, 0x8f, 0x13, 0xff, 0xec, 0x87, 0x0b, 0xff, 0xe9, 0x7f, 0x03, 0xff,
0xda, 0x72, 0x01, 0xff, 0xc4, 0x60, 0x01, 0xff, 0xdf, 0x6c, 0x01, 0xff, 0xd8, 0x62, 0x0c, 0xff,
0x79, 0x35, 0x09, 0xad, 0x7a, 0x5f, 0x1d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x7a, 0x5f, 0x1d, 0x00, 0x79, 0x59, 0x1a, 0x18, 0x88, 0x27, 0x02, 0xef, 0xef, 0x8e, 0x22, 0xff,
0xe7, 0x7a, 0x01, 0xff, 0xe5, 0x7c, 0x01, 0xff, 0xed, 0x8a, 0x0b, 0xff, 0xef, 0x96, 0x17, 0xff,
0xf2, 0xa1, 0x22, 0xff, 0xf3, 0xa7, 0x29, 0xff, 0xf5, 0xad, 0x30, 0xff, 0xf6, 0xb0, 0x33, 0xff,
0xdc, 0x9f, 0x30, 0xff, 0xbd, 0xa1, 0x6b, 0xff, 0xc3, 0xc3, 0xc3, 0xff, 0xc3, 0xc3, 0xc3, 0xff,
0xc3, 0xc3, 0xc3, 0xff, 0xc1, 0xb7, 0xa4, 0xff, 0xba, 0x89, 0x2f, 0xff, 0xdd, 0x9c, 0x2b, 0xff,
0xf3, 0xa8, 0x2a, 0xff, 0xf2, 0xa1, 0x22, 0xff, 0xef, 0x95, 0x17, 0xff, 0xed, 0x8a, 0x0b, 0xff,
0xe8, 0x7f, 0x01, 0xff, 0xd6, 0x6f, 0x01, 0xff, 0xf3, 0x93, 0x21, 0xff, 0xb1, 0x38, 0x01, 0xff,
0x78, 0x4f, 0x15, 0x43, 0x7a, 0x5f, 0x1d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00, 0x77, 0x44, 0x10, 0x6e, 0xd1, 0x55, 0x01, 0xff,
0xf8, 0xaa, 0x30, 0xff, 0xee, 0x8a, 0x0a, 0xff, 0xee, 0x95, 0x16, 0xff, 0xf5, 0xaa, 0x2c, 0xff,
0xf7, 0xb5, 0x38, 0xff, 0xfa, 0xbc, 0x3f, 0xff, 0xfb, 0xc2, 0x44, 0xff, 0xfc, 0xc5, 0x47, 0xff,
0xf7, 0xc2, 0x48, 0xff, 0xbc, 0x98, 0x44, 0xff, 0xbc, 0xb4, 0xa0, 0xff, 0xbc, 0xbc, 0xbc, 0xff,
0xbc, 0xb0, 0x95, 0xff, 0xbc, 0x96, 0x40, 0xff, 0xe3, 0xb1, 0x40, 0xff, 0xfb, 0xc2, 0x44, 0xff,
0xfa, 0xbc, 0x3f, 0xff, 0xf9, 0xb5, 0x39, 0xff, 0xf5, 0xaa, 0x2c, 0xff, 0xef, 0x97, 0x19, 0xff,
0xed, 0x87, 0x06, 0xff, 0xf7, 0xa3, 0x25, 0xff, 0xe0, 0x74, 0x13, 0xff, 0x77, 0x35, 0x0a, 0xa6,
0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00, 0x75, 0x33, 0x0a, 0xa7,
0xe5, 0x7c, 0x1a, 0xff, 0xfd, 0xc6, 0x4e, 0xff, 0xf6, 0xa4, 0x25, 0xff, 0xfa, 0xbc, 0x3f, 0xff,
0xfd, 0xca, 0x4e, 0xff, 0xfe, 0xd0, 0x54, 0xff, 0xff, 0xd6, 0x5a, 0xff, 0xff, 0xd9, 0x60, 0xff,
0xff, 0xdb, 0x5f, 0xff, 0xe5, 0xc6, 0x57, 0xff, 0xc9, 0xae, 0x4f, 0xff, 0xbb, 0xa3, 0x4e, 0xff,
0xcf, 0xb2, 0x4f, 0xff, 0xeb, 0xca, 0x58, 0xff, 0xff, 0xd9, 0x60, 0xff, 0xff, 0xd6, 0x5a, 0xff,
0xff, 0xd0, 0x54, 0xff, 0xfd, 0xca, 0x4e, 0xff, 0xf9, 0xbd, 0x3f, 0xff, 0xf4, 0xa2, 0x23, 0xff,
0xfa, 0xba, 0x3f, 0xff, 0xf2, 0x9e, 0x32, 0xff, 0x7a, 0x27, 0x05, 0xd6, 0x7a, 0x5d, 0x1b, 0x0e,
0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00, 0x7b, 0x5d, 0x1b, 0x10,
0x77, 0x29, 0x05, 0xd0, 0xf1, 0x9b, 0x36, 0xff, 0xff, 0xdf, 0x6b, 0xff, 0xfe, 0xc9, 0x4c, 0xff,
0xff, 0xd6, 0x5c, 0xff, 0xff, 0xe0, 0x65, 0xff, 0xff, 0xe5, 0x6a, 0xff, 0xff, 0xe8, 0x6d, 0xff,
0xff, 0xeb, 0x6f, 0xff, 0xff, 0xeb, 0x74, 0xff, 0xff, 0xeb, 0x74, 0xff, 0xfc, 0xe8, 0x72, 0xff,
0xff, 0xeb, 0x74, 0xff, 0xff, 0xeb, 0x6f, 0xff, 0xff, 0xe8, 0x6d, 0xff, 0xff, 0xe5, 0x6a, 0xff,
0xff, 0xe0, 0x65, 0xff, 0xff, 0xd8, 0x5e, 0xff, 0xfd, 0xc6, 0x48, 0xff, 0xff, 0xd5, 0x61, 0xff,
0xf9, 0xba, 0x4e, 0xff, 0x95, 0x2d, 0x02, 0xef, 0x7b, 0x56, 0x17, 0x31, 0x7a, 0x5f, 0x1d, 0x00,
0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00,
0x79, 0x59, 0x1a, 0x1e, 0x77, 0x28, 0x05, 0xd0, 0xef, 0x94, 0x34, 0xff, 0xff, 0xf7, 0x89, 0xff,
0xff, 0xea, 0x75, 0xff, 0xff, 0xe9, 0x6e, 0xff, 0xff, 0xf0, 0x73, 0xff, 0xff, 0xf3, 0x7b, 0xff,
0xff, 0xf4, 0x80, 0xff, 0xff, 0xf5, 0x82, 0xff, 0xff, 0xf4, 0x87, 0xff, 0xff, 0xf4, 0x87, 0xff,
0xff, 0xf5, 0x82, 0xff, 0xff, 0xf4, 0x80, 0xff, 0xff, 0xf3, 0x7c, 0xff, 0xff, 0xef, 0x79, 0xff,
0xff, 0xea, 0x6b, 0xff, 0xff, 0xe7, 0x6a, 0xff, 0xff, 0xf5, 0x85, 0xff, 0xf8, 0xb4, 0x51, 0xff,
0x94, 0x2e, 0x02, 0xed, 0x77, 0x4f, 0x15, 0x42, 0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00,
0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00,
0x7a, 0x5f, 0x1d, 0x00, 0x79, 0x5b, 0x1a, 0x16, 0x77, 0x2f, 0x09, 0xb3, 0xe8, 0x82, 0x2c, 0xff,
0xff, 0xee, 0x9b, 0xff, 0xff, 0xff, 0xa9, 0xff, 0xff, 0xff, 0x90, 0xff, 0xff, 0xfb, 0x85, 0xff,
0xff, 0xf7, 0x8c, 0xff, 0xfe, 0xf6, 0x94, 0xff, 0xfd, 0xf5, 0x98, 0xff, 0xfd, 0xf5, 0x98, 0xff,
0xfe, 0xf6, 0x94, 0xff, 0xff, 0xf7, 0x8e, 0xff, 0xff, 0xfa, 0x85, 0xff, 0xff, 0xfd, 0x8a, 0xff,
0xff, 0xff, 0xa2, 0xff, 0xff, 0xfb, 0xa5, 0xff, 0xef, 0x98, 0x3f, 0xff, 0x7c, 0x28, 0x05, 0xd4,
0x79, 0x54, 0x17, 0x33, 0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00,
0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00,
0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x01, 0x75, 0x39, 0x0d, 0x8c,
0xb8, 0x40, 0x01, 0xf8, 0xf1, 0xa1, 0x52, 0xff, 0xff, 0xe9, 0xaa, 0xff, 0xff, 0xff, 0xc8, 0xff,
0xff, 0xff, 0xc4, 0xff, 0xff, 0xff, 0xba, 0xff, 0xff, 0xff, 0xb2, 0xff, 0xff, 0xff, 0xb1, 0xff,
0xff, 0xff, 0xb7, 0xff, 0xff, 0xff, 0xc1, 0xff, 0xff, 0xff, 0xc8, 0xff, 0xff, 0xf4, 0xb4, 0xff,
0xf7, 0xb7, 0x6a, 0xff, 0xd7, 0x56, 0x04, 0xff, 0x75, 0x34, 0x0a, 0xa3, 0x79, 0x5b, 0x1b, 0x10,
0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00,
0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00,
0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00,
0x79, 0x52, 0x18, 0x2f, 0x76, 0x36, 0x0c, 0x97, 0x97, 0x38, 0x03, 0xe4, 0xde, 0x70, 0x20, 0xff,
0xef, 0xa3, 0x5b, 0xff, 0xf7, 0xc2, 0x85, 0xff, 0xfb, 0xd6, 0x9f, 0xff, 0xfb, 0xd9, 0xa1, 0xff,
0xf9, 0xc8, 0x8d, 0xff, 0xf3, 0xad, 0x68, 0xff, 0xe4, 0x7d, 0x2f, 0xff, 0xb3, 0x43, 0x02, 0xf1,
0x78, 0x31, 0x09, 0xae, 0x78, 0x4d, 0x15, 0x46, 0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00,
0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00,
0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00,
0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00,
0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00, 0x79, 0x5b, 0x1b, 0x11, 0x76, 0x4c, 0x15, 0x47,
0x70, 0x3b, 0x0f, 0x7b, 0x78, 0x35, 0x0a, 0xa3, 0x7e, 0x31, 0x08, 0xb7, 0x7e, 0x31, 0x08, 0xb7,
0x7b, 0x34, 0x0a, 0xab, 0x74, 0x3a, 0x0e, 0x85, 0x75, 0x47, 0x13, 0x55, 0x79, 0x58, 0x1a, 0x1e,
0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00,
0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00,
0x7a, 0x5f, 0x1d, 0x00, 0x7a, 0x5f, 0x1d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

int init_bitmap_suite(void)
{
	return 0;
}

int clean_bitmap_suite(void)
{
	return 0;
}

int add_bitmap_suite(void)
{
	add_test_suite(bitmap);

	add_test_function(bitmap);

	return 0;
}

void test_bitmap(void)
{
	struct btest
	{
		uint8 decompressed_16x1x8[16 * 1 * 1];
		uint8 decompressed_32x32x8[32 * 32 * 1];
		uint8 decompressed_16x1x16[16 * 1 * 2];
		uint8 decompressed_32x32x16[32 * 32 * 2];
		uint8 decompressed_16x1x24[16 * 1 * 3];
		uint8 decompressed_32x32x24[32 * 32 * 3];
		uint8 decompressed_16x1x32[16 * 1 * 4];
		uint8 decompressed_32x32x32[32 * 32 * 4];
	};
	struct btest* t;
	int width;
	int height;
	int comp_size;
	int decomp_size;
	int bpp;

	t = (struct btest*)malloc(sizeof(struct btest));
	width = 16;
	height = 1;
	bpp = 8;
	comp_size = sizeof(compressed_16x1x8);
	decomp_size = sizeof(decompressed_16x1x8);
	CU_ASSERT(bitmap_decompress(compressed_16x1x8, t->decompressed_16x1x8,
			width, height, comp_size, bpp, bpp) == true);
	CU_ASSERT(memcmp(t->decompressed_16x1x8, decompressed_16x1x8,
		decomp_size) == 0);

	width = 32;
	height = 32;
	bpp = 8;
	comp_size = sizeof(compressed_32x32x8);
	decomp_size = sizeof(decompressed_32x32x8);
	CU_ASSERT(bitmap_decompress(compressed_32x32x8, t->decompressed_32x32x8,
			width, height, comp_size, bpp, bpp) == true);
	CU_ASSERT(memcmp(t->decompressed_32x32x8, decompressed_32x32x8,
		decomp_size) == 0);

	width = 16;
	height = 1;
	bpp = 16;
	comp_size = sizeof(compressed_16x1x16);
	decomp_size = sizeof(decompressed_16x1x16);
	CU_ASSERT(bitmap_decompress(compressed_16x1x16, t->decompressed_16x1x16,
			width, height, comp_size, bpp, bpp) == true);
	CU_ASSERT(memcmp(t->decompressed_16x1x16, decompressed_16x1x16,
		decomp_size) == 0);

	width = 32;
	height = 32;
	bpp = 16;
	comp_size = sizeof(compressed_32x32x16);
	decomp_size = sizeof(decompressed_32x32x16);
	CU_ASSERT(bitmap_decompress(compressed_32x32x16, t->decompressed_32x32x16,
			width, height, comp_size, bpp, bpp) == true);
	CU_ASSERT(memcmp(t->decompressed_32x32x16, decompressed_32x32x16,
		decomp_size) == 0);

	width = 16;
	height = 1;
	bpp = 24;
	comp_size = sizeof(compressed_16x1x24);
	decomp_size = sizeof(decompressed_16x1x24);
	CU_ASSERT(bitmap_decompress(compressed_16x1x24, t->decompressed_16x1x24,
			width, height, comp_size, bpp, bpp) == true);
	CU_ASSERT(memcmp(t->decompressed_16x1x24, decompressed_16x1x24,
		decomp_size) == 0);

	width = 32;
	height = 32;
	bpp = 24;
	comp_size = sizeof(compressed_32x32x24);
	decomp_size = sizeof(decompressed_32x32x24);
	CU_ASSERT(bitmap_decompress(compressed_32x32x24, t->decompressed_32x32x24,
			width, height, comp_size, bpp, bpp) == true);
	CU_ASSERT(memcmp(t->decompressed_32x32x24, decompressed_32x32x24,
		decomp_size) == 0);

	width = 16;
	height = 1;
	bpp = 32;
	comp_size = sizeof(compressed_16x1x32);
	decomp_size = sizeof(decompressed_16x1x32);
	CU_ASSERT(bitmap_decompress(compressed_16x1x32, t->decompressed_16x1x32,
			width, height, comp_size, bpp, bpp) == true);
	CU_ASSERT(memcmp(t->decompressed_16x1x32, decompressed_16x1x32,
		decomp_size) == 0);

	width = 32;
	height = 32;
	bpp = 32;
	comp_size = sizeof(compressed_32x32x32);
	decomp_size = sizeof(decompressed_32x32x32);
	CU_ASSERT(bitmap_decompress(compressed_32x32x32, t->decompressed_32x32x32,
			width, height, comp_size, bpp, bpp) == true);
	CU_ASSERT(memcmp(t->decompressed_32x32x32, decompressed_32x32x32,
		decomp_size) == 0);

	free(t);
}
