# Case of the security policy

Some group policies are directly managed by **SSSD**. For those, **ADSys** is not involved at all. This is the case of the **Security Settings**.

In Windows Group Policy Management Editor, these keys are located in `[FOREST.ROOT] > Computer Configuration > Windows Settings > Security Settings`

The table below is a non-exhaustive list of Security Settings as defined in Windows and not managed by ADSys but still partially supported through SSSD.

| **Windows Setting** |
|---------------------|
|**Account Policies > Password Policy**|
|Enforce password history|
|Maximum password age|
|Minimum password age|
|Minimum password length|
|Password must meet complexity requirements|
|**Account Policies > Account Lockout Policy**|
|Account lockout duration|
|Account lockout threshold|
|Reset account lockout counter after|
|**Local Policies > User Rights Assignement**|
|Access this computer from the network|
|Allow log on locally|
|Allow log on through Remote Desktop Services|
|Change the system time|
|Change the timezone|
|Deny access to this computer from the network|
|Deny log on as a batch job|
|Deny log on as a service|
|Deny log on locally|
|Deny log on through Remote Desktop Services|
|Log on as a batch job|
|Log on as a service|
|Shutdown the system|
|**Local Policies / Security Options**|
|Administrator account status|
|Shutdown: Allow system to be shut down without having to log on|

You can get more information on SSSD [online](https://sssd.io/).
